/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.router.sharding;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.api.algorithm.sharding.ListShardingValue;
import io.shardingsphere.api.algorithm.sharding.PreciseShardingValue;
import io.shardingsphere.api.algorithm.sharding.ShardingValue;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.ShardingOperator;
import io.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.optimizer.OptimizeEngineFactory;
import io.shardingsphere.core.optimizer.condition.ShardingCondition;
import io.shardingsphere.core.optimizer.condition.ShardingConditions;
import io.shardingsphere.core.parsing.SQLParsingEngine;
import io.shardingsphere.core.parsing.parser.context.condition.AndCondition;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.context.condition.Condition;
import io.shardingsphere.core.parsing.parser.context.condition.GeneratedKeyCondition;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowDatabasesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTableStatusStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTablesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.UseStatement;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.statement.ResetParamStatement;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.statement.SetParamStatement;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dcl.DCLStatement;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.rewrite.SQLBuilder;
import io.shardingsphere.core.rewrite.SQLRewriteEngine;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import io.shardingsphere.core.routing.router.sharding.ShardingRouter;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.routing.type.broadcast.DatabaseBroadcastRoutingEngine;
import io.shardingsphere.core.routing.type.broadcast.InstanceBroadcastRoutingEngine;
import io.shardingsphere.core.routing.type.broadcast.TableBroadcastRoutingEngine;
import io.shardingsphere.core.routing.type.complex.ComplexRoutingEngine;
import io.shardingsphere.core.routing.type.defaultdb.DefaultDatabaseRoutingEngine;
import io.shardingsphere.core.routing.type.ignore.IgnoreRoutingEngine;
import io.shardingsphere.core.routing.type.standard.StandardRoutingEngine;
import io.shardingsphere.core.routing.type.unicast.UnicastRoutingEngine;
import io.shardingsphere.core.rule.BindingTableRule;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import io.shardingsphere.core.util.SQLLogger;
import io.shardingsphere.spi.parsing.ParsingHook;
import io.shardingsphere.spi.parsing.SPIParsingHook;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class ParsingSQLRouter
implements ShardingRouter {
    private final ShardingRule shardingRule;
    private final ShardingTableMetaData shardingTableMetaData;
    private final DatabaseType databaseType;
    private final boolean showSQL;
    private final List<Number> generatedKeys = new LinkedList<Number>();
    private final ShardingDataSourceMetaData shardingDataSourceMetaData;
    private final ParsingHook parsingHook = new SPIParsingHook();

    @Override
    public SQLStatement parse(String logicSQL, boolean useCache) {
        this.parsingHook.start(logicSQL);
        try {
            SQLStatement result = new SQLParsingEngine(this.databaseType, logicSQL, this.shardingRule, this.shardingTableMetaData).parse(useCache);
            this.parsingHook.finishSuccess();
            return result;
        }
        catch (Exception ex) {
            this.parsingHook.finishFailure(ex);
            throw ex;
        }
    }

    @Override
    public SQLRouteResult route(String logicSQL, List<Object> parameters, SQLStatement sqlStatement) {
        GeneratedKey generatedKey = null;
        if (sqlStatement instanceof InsertStatement) {
            generatedKey = this.getGenerateKey(this.shardingRule, (InsertStatement)sqlStatement, parameters);
        }
        SQLRouteResult result = new SQLRouteResult(sqlStatement, generatedKey);
        ShardingConditions shardingConditions = OptimizeEngineFactory.newInstance(this.shardingRule, sqlStatement, parameters, generatedKey).optimize();
        if (null != generatedKey) {
            this.setGeneratedKeys(result, generatedKey);
        }
        this.checkAndMergeShardingValue(sqlStatement, shardingConditions);
        RoutingResult routingResult = this.route(sqlStatement, shardingConditions);
        SQLRewriteEngine rewriteEngine = new SQLRewriteEngine(this.shardingRule, logicSQL, this.databaseType, sqlStatement, shardingConditions, parameters);
        boolean isSingleRouting = routingResult.isSingleRouting();
        if (sqlStatement instanceof SelectStatement && null != ((SelectStatement)sqlStatement).getLimit()) {
            this.processLimit(parameters, (SelectStatement)sqlStatement);
        }
        SQLBuilder sqlBuilder = rewriteEngine.rewrite(!isSingleRouting);
        for (TableUnit each : routingResult.getTableUnits().getTableUnits()) {
            result.getRouteUnits().add(new RouteUnit(each.getDataSourceName(), rewriteEngine.generateSQL(each, sqlBuilder, this.shardingDataSourceMetaData)));
        }
        if (this.showSQL) {
            SQLLogger.logSQL(logicSQL, sqlStatement, result.getRouteUnits());
        }
        return result;
    }

    private void checkAndMergeShardingValue(SQLStatement sqlStatement, ShardingConditions shardingConditions) {
        if (!(sqlStatement instanceof SelectStatement)) {
            return;
        }
        SelectStatement selectStatement = (SelectStatement)sqlStatement;
        if (selectStatement.getSubQueryStatements().isEmpty()) {
            return;
        }
        for (AndCondition each : sqlStatement.getConditions().getOrCondition().getAndConditions()) {
            for (Condition eachCondition : each.getConditions()) {
                Preconditions.checkState((ShardingOperator.EQUAL == eachCondition.getOperator() ? 1 : 0) != 0, (Object)"DQL only support '=' with subquery.");
            }
        }
        Preconditions.checkState((!shardingConditions.getShardingConditions().isEmpty() ? 1 : 0) != 0, (Object)"DQL must have sharding column with subquery.");
        ShardingCondition firstShardingCondition = shardingConditions.getShardingConditions().iterator().next();
        Iterator<ShardingCondition> iterator = shardingConditions.getShardingConditions().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        int size = firstShardingCondition.getShardingValues().size();
        while (iterator.hasNext()) {
            ShardingCondition each = iterator.next();
            Preconditions.checkState((size == each.getShardingValues().size() ? 1 : 0) != 0, (Object)"DQL sharding value size must be same with subquery.");
            for (ShardingValue eachFirstValue : firstShardingCondition.getShardingValues()) {
                ShardingValue eachValue;
                boolean ok = false;
                Iterator<ShardingValue> iterator2 = each.getShardingValues().iterator();
                while (iterator2.hasNext() && !(ok = this.checkAndMergeShardingValue(iterator, eachFirstValue, eachValue = iterator2.next()))) {
                }
                Preconditions.checkState((boolean)ok, (Object)"DQL sharding value must be in single sharding with subquery.");
            }
        }
    }

    private boolean checkAndMergeShardingValue(Iterator<ShardingCondition> iterator, ShardingValue shardingValue1, ShardingValue shardingValue2) {
        if (shardingValue1.getClass() != shardingValue2.getClass()) {
            return false;
        }
        if (!shardingValue1.getColumnName().equalsIgnoreCase(shardingValue2.getColumnName())) {
            return false;
        }
        if (!shardingValue1.getLogicTableName().equals(shardingValue2.getLogicTableName())) {
            Optional<BindingTableRule> bindingRule = this.shardingRule.findBindingTableRule(shardingValue1.getLogicTableName());
            if (!bindingRule.isPresent() || !((BindingTableRule)bindingRule.get()).hasLogicTable(shardingValue2.getLogicTableName())) {
                return false;
            }
            iterator.remove();
        }
        if (shardingValue1 instanceof PreciseShardingValue && 0 == ((PreciseShardingValue)shardingValue1).getValue().compareTo(((PreciseShardingValue)shardingValue2).getValue())) {
            return true;
        }
        if (shardingValue1 instanceof ListShardingValue) {
            Collection values1 = ((ListShardingValue)shardingValue1).getValues();
            Collection values2 = ((ListShardingValue)shardingValue2).getValues();
            if (values1.size() != values2.size()) {
                return false;
            }
            for (Object each : values1) {
                if (values2.contains(each)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private RoutingResult route(SQLStatement sqlStatement, ShardingConditions shardingConditions) {
        Collection<String> tableNames = sqlStatement.getTables().getTableNames();
        RoutingEngine routingEngine = sqlStatement instanceof UseStatement ? new IgnoreRoutingEngine() : (this.shardingRule.isAllBroadcastTables(tableNames) && !(sqlStatement instanceof SelectStatement) ? new DatabaseBroadcastRoutingEngine(this.shardingRule) : (sqlStatement instanceof DDLStatement || sqlStatement instanceof DCLStatement && ((DCLStatement)sqlStatement).isGrantForSingleTable() ? new TableBroadcastRoutingEngine(this.shardingRule, sqlStatement) : (sqlStatement instanceof ShowDatabasesStatement || (sqlStatement instanceof ShowTablesStatement || sqlStatement instanceof ShowTableStatusStatement) && tableNames.isEmpty() || sqlStatement instanceof SetParamStatement || sqlStatement instanceof ResetParamStatement ? new DatabaseBroadcastRoutingEngine(this.shardingRule) : (sqlStatement instanceof DCLStatement ? new InstanceBroadcastRoutingEngine(this.shardingRule, this.shardingDataSourceMetaData) : (this.shardingRule.isAllInDefaultDataSource(tableNames) ? new DefaultDatabaseRoutingEngine(this.shardingRule, tableNames) : (shardingConditions.isAlwaysFalse() ? new UnicastRoutingEngine(this.shardingRule, tableNames) : (sqlStatement instanceof DALStatement ? new UnicastRoutingEngine(this.shardingRule, tableNames) : (tableNames.isEmpty() && sqlStatement instanceof SelectStatement || this.shardingRule.isAllBroadcastTables(tableNames) && sqlStatement instanceof SelectStatement ? new UnicastRoutingEngine(this.shardingRule, tableNames) : (tableNames.isEmpty() ? new DatabaseBroadcastRoutingEngine(this.shardingRule) : (1 == tableNames.size() || this.shardingRule.isAllBindingTables(tableNames) ? new StandardRoutingEngine(this.shardingRule, tableNames.iterator().next(), shardingConditions) : new ComplexRoutingEngine(this.shardingRule, tableNames, shardingConditions)))))))))));
        return routingEngine.route();
    }

    private GeneratedKey getGenerateKey(ShardingRule shardingRule, InsertStatement insertStatement, List<Object> parameters) {
        GeneratedKey result = null;
        if (-1 != insertStatement.getGenerateKeyColumnIndex()) {
            for (GeneratedKeyCondition generatedKeyCondition : insertStatement.getGeneratedKeyConditions()) {
                if (null == result) {
                    result = new GeneratedKey(generatedKeyCondition.getColumn());
                }
                if (-1 == generatedKeyCondition.getIndex()) {
                    result.getGeneratedKeys().add(generatedKeyCondition.getValue());
                    continue;
                }
                result.getGeneratedKeys().add((Number)parameters.get(generatedKeyCondition.getIndex()));
            }
            return result;
        }
        String logicTableName = insertStatement.getTables().getSingleTableName();
        Optional<TableRule> tableRule = shardingRule.tryFindTableRuleByLogicTable(logicTableName);
        if (!tableRule.isPresent()) {
            return null;
        }
        Optional<Column> generateKeyColumn = shardingRule.getGenerateKeyColumn(logicTableName);
        if (generateKeyColumn.isPresent()) {
            result = new GeneratedKey((Column)generateKeyColumn.get());
            for (int i = 0; i < insertStatement.getInsertValues().getInsertValues().size(); ++i) {
                result.getGeneratedKeys().add(shardingRule.generateKey(logicTableName));
            }
        }
        return result;
    }

    private void setGeneratedKeys(SQLRouteResult sqlRouteResult, GeneratedKey generatedKey) {
        this.generatedKeys.addAll(generatedKey.getGeneratedKeys());
        sqlRouteResult.getGeneratedKey().getGeneratedKeys().clear();
        sqlRouteResult.getGeneratedKey().getGeneratedKeys().addAll(this.generatedKeys);
    }

    private void processLimit(List<Object> parameters, SelectStatement selectStatement) {
        boolean isNeedFetchAll = (!selectStatement.getGroupByItems().isEmpty() || !selectStatement.getAggregationSelectItems().isEmpty()) && !selectStatement.isSameGroupByAndOrderByItems();
        selectStatement.getLimit().processParameters(parameters, isNeedFetchAll);
    }

    @ConstructorProperties(value={"shardingRule", "shardingTableMetaData", "databaseType", "showSQL", "shardingDataSourceMetaData"})
    public ParsingSQLRouter(ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData, DatabaseType databaseType, boolean showSQL, ShardingDataSourceMetaData shardingDataSourceMetaData) {
        this.shardingRule = shardingRule;
        this.shardingTableMetaData = shardingTableMetaData;
        this.databaseType = databaseType;
        this.showSQL = showSQL;
        this.shardingDataSourceMetaData = shardingDataSourceMetaData;
    }
}

