/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.dql.select;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.core.parsing.parser.context.OrderItem;
import io.shardingsphere.core.parsing.parser.context.limit.Limit;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationDistinctSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.DistinctSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.SelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.StarSelectItem;
import io.shardingsphere.core.parsing.parser.context.table.Table;
import io.shardingsphere.core.parsing.parser.sql.dql.DQLStatement;
import io.shardingsphere.core.parsing.parser.token.OffsetToken;
import io.shardingsphere.core.parsing.parser.token.RowCountToken;
import io.shardingsphere.core.parsing.parser.token.SQLToken;
import io.shardingsphere.core.util.SQLUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SelectStatement
extends DQLStatement {
    private boolean containStar;
    private int selectListLastPosition;
    private int groupByLastPosition;
    private final Set<SelectItem> items = new HashSet<SelectItem>();
    private final List<OrderItem> groupByItems = new LinkedList<OrderItem>();
    private final List<OrderItem> orderByItems = new LinkedList<OrderItem>();
    private Limit limit;
    private SelectStatement subQueryStatement;
    private Collection<SelectStatement> subQueryStatements = new LinkedList<SelectStatement>();

    public Optional<String> getAlias(String name) {
        if (this.containStar) {
            return Optional.absent();
        }
        String rawName = SQLUtil.getExactlyValue(name);
        for (SelectItem each : this.items) {
            if (rawName.equalsIgnoreCase(SQLUtil.getExactlyValue(each.getExpression()))) {
                return each.getAlias();
            }
            if (!rawName.equalsIgnoreCase((String)each.getAlias().orNull())) continue;
            return Optional.of((Object)rawName);
        }
        return Optional.absent();
    }

    public List<AggregationSelectItem> getAggregationSelectItems() {
        LinkedList<AggregationSelectItem> result = new LinkedList<AggregationSelectItem>();
        for (SelectItem each : this.items) {
            if (!(each instanceof AggregationSelectItem)) continue;
            AggregationSelectItem aggregationSelectItem = (AggregationSelectItem)each;
            result.add(aggregationSelectItem);
            result.addAll(aggregationSelectItem.getDerivedAggregationSelectItems());
        }
        return result;
    }

    public List<DistinctSelectItem> getDistinctSelectItems() {
        LinkedList<DistinctSelectItem> result = new LinkedList<DistinctSelectItem>();
        for (SelectItem each : this.items) {
            if (!(each instanceof DistinctSelectItem)) continue;
            DistinctSelectItem distinctSelectItem = (DistinctSelectItem)each;
            result.add(distinctSelectItem);
        }
        return result;
    }

    public List<AggregationDistinctSelectItem> getAggregationDistinctSelectItems() {
        LinkedList<AggregationDistinctSelectItem> result = new LinkedList<AggregationDistinctSelectItem>();
        for (SelectItem each : this.items) {
            if (!(each instanceof AggregationDistinctSelectItem)) continue;
            AggregationDistinctSelectItem distinctSelectItem = (AggregationDistinctSelectItem)each;
            result.add(distinctSelectItem);
        }
        return result;
    }

    public boolean hasUnqualifiedStarSelectItem() {
        for (SelectItem each : this.items) {
            if (!(each instanceof StarSelectItem) || ((StarSelectItem)each).getOwner().isPresent()) continue;
            return true;
        }
        return false;
    }

    public Collection<StarSelectItem> getQualifiedStarSelectItems() {
        LinkedList<StarSelectItem> result = new LinkedList<StarSelectItem>();
        for (SelectItem each : this.items) {
            if (!(each instanceof StarSelectItem) || !((StarSelectItem)each).getOwner().isPresent()) continue;
            result.add((StarSelectItem)each);
        }
        return result;
    }

    public Optional<StarSelectItem> findStarSelectItem(String tableNameOrAlias) {
        Optional<Table> table = this.getTables().find(tableNameOrAlias);
        if (!table.isPresent()) {
            return Optional.absent();
        }
        for (SelectItem each : this.items) {
            StarSelectItem starSelectItem;
            if (!(each instanceof StarSelectItem) || !(starSelectItem = (StarSelectItem)each).getOwner().isPresent() || !this.getTables().find((String)starSelectItem.getOwner().get()).equals(table)) continue;
            return Optional.of((Object)starSelectItem);
        }
        return Optional.absent();
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.getGroupByItems().isEmpty() && this.getGroupByItems().equals(this.getOrderByItems());
    }

    public void setIndexForItems(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationItem(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByItems);
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByItems);
    }

    private void setIndexForAggregationItem(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationSelectItem each : this.getAggregationSelectItems()) {
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (String)"Can't find index: %s, please add alias for aggregate selections", (Object[])new Object[]{each});
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
            for (AggregationSelectItem derived : each.getDerivedAggregationSelectItems()) {
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derived.getColumnLabel()), (String)"Can't find index: %s", (Object[])new Object[]{derived});
                derived.setIndex(columnLabelIndexMap.get(derived.getColumnLabel()));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, List<OrderItem> orderItems) {
        for (OrderItem each : orderItems) {
            if (-1 != each.getIndex()) continue;
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (String)"Can't find index: %s", (Object[])new Object[]{each});
            if (!columnLabelIndexMap.containsKey(each.getColumnLabel())) continue;
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
        }
    }

    public void setSubQueryStatement(SelectStatement subQueryStatement) {
        this.subQueryStatement = subQueryStatement;
        this.setParametersIndex(subQueryStatement.getParametersIndex());
    }

    public boolean containsSubQuery() {
        return null != this.subQueryStatement;
    }

    public SelectStatement mergeSubQueryStatement() {
        SelectStatement result = this.processLimitForSubQuery();
        this.processItems(result);
        this.processOrderByItems(result);
        result.setParametersIndex(this.getParametersIndex());
        return result;
    }

    private SelectStatement processLimitForSubQuery() {
        SelectStatement result = this;
        List<SQLToken> limitSQLTokens = this.getLimitTokens(result);
        Limit limit = result.getLimit();
        while (result.containsSubQuery()) {
            result = result.subQueryStatement;
            limitSQLTokens.addAll(this.getLimitTokens(result));
            if (null == result.getLimit()) continue;
            if (null == limit) {
                limit = result.getLimit();
            }
            if (null != result.getLimit().getRowCount()) {
                limit.setRowCount(result.getLimit().getRowCount());
            }
            if (null == result.getLimit().getOffset()) continue;
            limit.setOffset(result.getLimit().getOffset());
        }
        this.resetLimitTokens(result, limitSQLTokens);
        result.setLimit(limit);
        return result;
    }

    private List<SQLToken> getLimitTokens(SelectStatement selectStatement) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (SQLToken each : selectStatement.getSQLTokens()) {
            if (!(each instanceof RowCountToken) && !(each instanceof OffsetToken)) continue;
            result.add(each);
        }
        return result;
    }

    private void resetLimitTokens(SelectStatement selectStatement, List<SQLToken> limitSQLTokens) {
        int count = 0;
        LinkedList<Integer> toBeRemovedIndexes = new LinkedList<Integer>();
        List<SQLToken> sqlTokens = selectStatement.getSQLTokens();
        for (SQLToken each : sqlTokens) {
            if (each instanceof RowCountToken || each instanceof OffsetToken) {
                toBeRemovedIndexes.add(count);
            }
            ++count;
        }
        Iterator<SQLToken> iterator = toBeRemovedIndexes.iterator();
        while (iterator.hasNext()) {
            int each = (Integer)((Object)iterator.next());
            sqlTokens.remove(each);
        }
        sqlTokens.addAll(limitSQLTokens);
    }

    private void processItems(SelectStatement subQueryStatement) {
        if (!this.containStar) {
            subQueryStatement.getItems().clear();
            subQueryStatement.getItems().addAll(this.getItems());
        }
    }

    private void processOrderByItems(SelectStatement subQueryStatement) {
        if (!this.containStar) {
            subQueryStatement.getOrderByItems().clear();
            subQueryStatement.getGroupByItems().clear();
        }
    }

    public boolean isContainStar() {
        return this.containStar;
    }

    public int getSelectListLastPosition() {
        return this.selectListLastPosition;
    }

    public int getGroupByLastPosition() {
        return this.groupByLastPosition;
    }

    public Set<SelectItem> getItems() {
        return this.items;
    }

    public List<OrderItem> getGroupByItems() {
        return this.groupByItems;
    }

    public List<OrderItem> getOrderByItems() {
        return this.orderByItems;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public SelectStatement getSubQueryStatement() {
        return this.subQueryStatement;
    }

    public Collection<SelectStatement> getSubQueryStatements() {
        return this.subQueryStatements;
    }

    public void setContainStar(boolean containStar) {
        this.containStar = containStar;
    }

    public void setSelectListLastPosition(int selectListLastPosition) {
        this.selectListLastPosition = selectListLastPosition;
    }

    public void setGroupByLastPosition(int groupByLastPosition) {
        this.groupByLastPosition = groupByLastPosition;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public void setSubQueryStatements(Collection<SelectStatement> subQueryStatements) {
        this.subQueryStatements = subQueryStatements;
    }

    @Override
    public String toString() {
        return "SelectStatement(super=" + super.toString() + ", containStar=" + this.isContainStar() + ", selectListLastPosition=" + this.getSelectListLastPosition() + ", groupByLastPosition=" + this.getGroupByLastPosition() + ", items=" + this.getItems() + ", groupByItems=" + this.getGroupByItems() + ", orderByItems=" + this.getOrderByItems() + ", limit=" + this.getLimit() + ", subQueryStatement=" + this.getSubQueryStatement() + ", subQueryStatements=" + this.getSubQueryStatements() + ")";
    }
}

