/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.alter.table;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingsphere.core.parsing.parser.sql.SQLParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.rule.ShardingRule;

public abstract class AbstractAlterTableParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public AbstractAlterTableParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = new TableReferencesClauseParser(shardingRule, lexerEngine);
    }

    @Override
    public final DDLStatement parse() {
        this.lexerEngine.unsupportedIfNotSkip(DefaultKeyword.TABLE);
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenAlterTableAndTableName());
        DDLStatement result = new DDLStatement();
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        return result;
    }

    protected abstract Keyword[] getSkippedKeywordsBetweenAlterTableAndTableName();

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    protected TableReferencesClauseParser getTableReferencesClauseParser() {
        return this.tableReferencesClauseParser;
    }
}

