/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.sqlserver.clause;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.sqlserver.SQLServerKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingsphere.core.parsing.parser.context.limit.Limit;
import io.shardingsphere.core.parsing.parser.context.limit.LimitValue;
import io.shardingsphere.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.expression.SQLExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLNumberExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLPlaceholderExpression;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.RowCountToken;

public final class SQLServerTopClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public SQLServerTopClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(SelectStatement selectStatement) {
        LimitValue rowCountValue;
        if (!this.lexerEngine.skipIfEqual(SQLServerKeyword.TOP)) {
            return;
        }
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        if (!this.lexerEngine.skipIfEqual(Symbol.LEFT_PAREN)) {
            beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
        }
        SQLExpression sqlExpression = this.basicExpressionParser.parse(selectStatement);
        this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
        if (sqlExpression instanceof SQLNumberExpression) {
            int rowCount = ((SQLNumberExpression)sqlExpression).getNumber().intValue();
            rowCountValue = new LimitValue(rowCount, -1, false);
            selectStatement.addSQLToken(new RowCountToken(beginPosition, rowCount));
        } else if (sqlExpression instanceof SQLPlaceholderExpression) {
            rowCountValue = new LimitValue(-1, ((SQLPlaceholderExpression)sqlExpression).getIndex(), false);
        } else {
            throw new SQLParsingException(this.lexerEngine);
        }
        this.lexerEngine.unsupportedIfEqual(SQLServerKeyword.PERCENT);
        this.lexerEngine.skipIfEqual(DefaultKeyword.WITH, SQLServerKeyword.TIES);
        if (null == selectStatement.getLimit()) {
            Limit limit = new Limit(DatabaseType.SQLServer);
            limit.setRowCount(rowCountValue);
            selectStatement.setLimit(limit);
        } else {
            selectStatement.getLimit().setRowCount(rowCountValue);
        }
    }
}

