/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.AggregationType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.expression.AliasExpressionParser;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationDistinctSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.CommonSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.DistinctSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.SelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.StarSelectItem;
import io.shardingsphere.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.AggregationDistinctToken;
import io.shardingsphere.core.parsing.parser.token.TableToken;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.SQLUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SelectListClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final AliasExpressionParser aliasExpressionParser;

    public SelectListClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.aliasExpressionParser = ExpressionParserFactory.createAliasExpressionParser(lexerEngine);
    }

    public void parse(SelectStatement selectStatement, List<SelectItem> items) {
        do {
            selectStatement.getItems().addAll(this.parseSelectItems(selectStatement));
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        selectStatement.setSelectListLastPosition(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
        items.addAll(selectStatement.getItems());
    }

    private Collection<SelectItem> parseSelectItems(SelectStatement selectStatement) {
        this.lexerEngine.skipIfEqual(this.getSkippedKeywordsBeforeSelectItem());
        Collection<SelectItem> result = this.getSelectItems(selectStatement);
        this.reviseDistinctSelectItems(selectStatement, result);
        return result;
    }

    private Collection<SelectItem> getSelectItems(SelectStatement selectStatement) {
        LinkedList<SelectItem> result = new LinkedList<SelectItem>();
        if (this.isRowNumberSelectItem()) {
            result.add(this.parseRowNumberSelectItem(selectStatement));
        } else if (this.isDistinctSelectItem()) {
            result.add(this.parseDistinctSelectItem(selectStatement));
            this.addStarSelectItem(result);
            this.parseRestSelectItem(selectStatement);
        } else if (this.isStarSelectItem()) {
            selectStatement.setContainStar(true);
            result.add(this.parseStarSelectItem());
        } else if (this.isAggregationSelectItem()) {
            result.add(this.parseAggregationSelectItem(selectStatement));
            this.parseRestSelectItem(selectStatement);
        } else {
            result.add(this.parseCommonOrStarSelectItem(selectStatement));
        }
        return result;
    }

    private void addStarSelectItem(Collection<SelectItem> result) {
        if (this.isStarSelectItem()) {
            result.add(this.parseStarSelectItem());
        }
    }

    private void reviseDistinctSelectItems(SelectStatement selectStatement, Collection<SelectItem> selectItems) {
        for (SelectItem each : selectItems) {
            if (selectStatement.getDistinctSelectItems().isEmpty() || each instanceof StarSelectItem) continue;
            selectStatement.getDistinctSelectItems().get(0).getDistinctColumnNames().add(each.getAlias().isPresent() ? (String)each.getAlias().get() : each.getExpression());
        }
    }

    protected abstract Keyword[] getSkippedKeywordsBeforeSelectItem();

    protected abstract boolean isRowNumberSelectItem();

    protected abstract SelectItem parseRowNumberSelectItem(SelectStatement var1);

    private boolean isDistinctSelectItem() {
        return this.lexerEngine.equalAny(DefaultKeyword.DISTINCT);
    }

    private SelectItem parseDistinctSelectItem(SelectStatement selectStatement) {
        this.lexerEngine.nextToken();
        String distinctColumnName = this.lexerEngine.getCurrentToken().getLiterals();
        if (Symbol.STAR == this.lexerEngine.getCurrentToken().getType()) {
            return new DistinctSelectItem(Collections.emptyList(), this.aliasExpressionParser.parseSelectItemAlias());
        }
        this.lexerEngine.nextToken();
        distinctColumnName = SQLUtil.getExactlyValue(distinctColumnName + this.parseRestSelectItem(selectStatement));
        return new DistinctSelectItem(Collections.singletonList(distinctColumnName), this.aliasExpressionParser.parseSelectItemAlias());
    }

    private boolean isStarSelectItem() {
        return Symbol.STAR.getLiterals().equals(SQLUtil.getExactlyValue(this.lexerEngine.getCurrentToken().getLiterals()));
    }

    private SelectItem parseStarSelectItem() {
        this.lexerEngine.nextToken();
        this.aliasExpressionParser.parseSelectItemAlias();
        return new StarSelectItem((Optional<String>)Optional.absent());
    }

    private SelectItem parseStarSelectItem(String owner) {
        this.lexerEngine.nextToken();
        this.aliasExpressionParser.parseSelectItemAlias();
        return new StarSelectItem((Optional<String>)Optional.fromNullable((Object)owner));
    }

    private SelectItem parseCommonOrStarSelectItem(SelectStatement selectStatement) {
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        int position = this.lexerEngine.getCurrentToken().getEndPosition() - literals.length();
        StringBuilder result = new StringBuilder();
        result.append(literals);
        this.lexerEngine.nextToken();
        if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
            result.append(this.lexerEngine.skipParentheses(selectStatement));
        } else if (this.lexerEngine.equalAny(Symbol.DOT)) {
            String tableName = SQLUtil.getExactlyValue(literals);
            if (this.shardingRule.tryFindTableRuleByLogicTable(tableName).isPresent() || this.shardingRule.isBroadcastTable(tableName) || this.shardingRule.findBindingTableRule(tableName).isPresent()) {
                selectStatement.addSQLToken(new TableToken(position, 0, literals));
            }
            result.append(this.lexerEngine.getCurrentToken().getLiterals());
            this.lexerEngine.nextToken();
            if (this.lexerEngine.equalAny(Symbol.STAR)) {
                return this.parseStarSelectItem(literals);
            }
            result.append(this.lexerEngine.getCurrentToken().getLiterals());
            this.lexerEngine.nextToken();
        }
        return new CommonSelectItem(SQLUtil.getExactlyValue(result + this.parseRestSelectItem(selectStatement)), this.aliasExpressionParser.parseSelectItemAlias());
    }

    private boolean isAggregationSelectItem() {
        return this.lexerEngine.equalAny(DefaultKeyword.MAX, DefaultKeyword.MIN, DefaultKeyword.SUM, DefaultKeyword.AVG, DefaultKeyword.COUNT);
    }

    private SelectItem parseAggregationSelectItem(SelectStatement selectStatement) {
        AggregationType aggregationType = AggregationType.valueOf(this.lexerEngine.getCurrentToken().getLiterals().toUpperCase());
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
        this.lexerEngine.nextToken();
        String innerExpression = this.lexerEngine.skipParentheses(selectStatement);
        return this.isAggregationDistinctSelectItem(innerExpression) ? this.getAggregationDistinctSelectItem(selectStatement, aggregationType, beginPosition, innerExpression) : new AggregationSelectItem(aggregationType, innerExpression, this.aliasExpressionParser.parseSelectItemAlias());
    }

    private SelectItem getAggregationDistinctSelectItem(SelectStatement selectStatement, AggregationType aggregationType, int beginPosition, String innerExpression) {
        AggregationDistinctSelectItem result = new AggregationDistinctSelectItem(aggregationType, innerExpression, this.aliasExpressionParser.parseSelectItemAlias(), this.getDistinctColumnName(innerExpression));
        selectStatement.getSQLTokens().add(new AggregationDistinctToken(beginPosition, SQLUtil.getExactlyValue(aggregationType.name() + innerExpression), result.getDistinctColumnName()));
        return result;
    }

    private boolean isAggregationDistinctSelectItem(String innerExpression) {
        String pattern = "\\(\\s*DISTINCT\\s+.*\\)";
        return Pattern.matches(pattern, innerExpression.toUpperCase());
    }

    private String getDistinctColumnName(String innerExpression) {
        Pattern pattern = Pattern.compile("\\(\\s*DISTINCT\\s+(\\S+)\\s*\\)", 2);
        Matcher matcher = pattern.matcher(innerExpression);
        String result = "";
        if (matcher.find()) {
            result = matcher.group(1);
        }
        return result;
    }

    private String parseRestSelectItem(SelectStatement selectStatement) {
        StringBuilder result = new StringBuilder();
        while (this.lexerEngine.equalAny(Symbol.getOperators())) {
            result.append(this.lexerEngine.getCurrentToken().getLiterals());
            this.lexerEngine.nextToken();
            SelectItem selectItem = this.parseCommonOrStarSelectItem(selectStatement);
            result.append(selectItem.getExpression());
        }
        return result.toString();
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    public AliasExpressionParser getAliasExpressionParser() {
        return this.aliasExpressionParser;
    }
}

