/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.rule.registry.statement;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import io.shardingsphere.core.parsing.antlr.extractor.SQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.optimizer.SQLStatementOptimizer;
import io.shardingsphere.core.parsing.antlr.rule.jaxb.entity.statement.SQLStatementRuleDefinitionEntity;
import io.shardingsphere.core.parsing.antlr.rule.jaxb.entity.statement.SQLStatementRuleEntity;
import io.shardingsphere.core.parsing.antlr.rule.registry.extractor.ExtractorRuleDefinition;
import io.shardingsphere.core.parsing.antlr.rule.registry.statement.SQLStatementRule;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public final class SQLStatementRuleDefinition {
    private final Map<String, SQLStatementRule> rules = new LinkedHashMap<String, SQLStatementRule>();

    public void init(SQLStatementRuleDefinitionEntity dialectRuleDefinitionEntity, ExtractorRuleDefinition extractorRuleDefinition) {
        for (SQLStatementRuleEntity each : dialectRuleDefinitionEntity.getRules()) {
            SQLStatementRule sqlStatementRule = new SQLStatementRule(each.getContext(), Class.forName(each.getSqlStatementClass()), (SQLStatementOptimizer)this.newClassInstance(dialectRuleDefinitionEntity.getOptimizerBasePackage(), each.getOptimizerClass()));
            sqlStatementRule.getExtractors().addAll(this.createExtractors(each.getExtractorRuleRefs(), extractorRuleDefinition));
            this.rules.put(this.getContextClassName(each.getContext()), sqlStatementRule);
        }
    }

    private Collection<SQLSegmentExtractor> createExtractors(String sqlExtractorRuleRefs, ExtractorRuleDefinition extractorRuleDefinition) {
        LinkedList<SQLSegmentExtractor> result = new LinkedList<SQLSegmentExtractor>();
        if (sqlExtractorRuleRefs != null) {
            for (String each : Splitter.on((char)',').trimResults().splitToList((CharSequence)sqlExtractorRuleRefs)) {
                result.add(extractorRuleDefinition.getRules().get(each));
            }
        }
        return result;
    }

    private String getContextClassName(String context) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, context + "Context");
    }

    private Object newClassInstance(String basePackage, String className) {
        return Strings.isNullOrEmpty((String)className) ? null : Class.forName(Joiner.on((char)'.').join((Object)basePackage, (Object)className, new Object[0])).newInstance();
    }

    public Map<String, SQLStatementRule> getRules() {
        return this.rules;
    }
}

