/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.optimizer.impl.ddl;

import io.shardingsphere.core.metadata.table.ColumnMetaData;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.metadata.table.TableMetaData;
import io.shardingsphere.core.parsing.antlr.optimizer.SQLStatementOptimizer;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.ddl.create.table.CreateTableStatement;
import java.util.LinkedList;
import java.util.List;

public final class CreateTableOptimizer
implements SQLStatementOptimizer {
    @Override
    public void optimize(SQLStatement sqlStatement, ShardingTableMetaData shardingTableMetaData) {
        CreateTableStatement createStatement = (CreateTableStatement)sqlStatement;
        LinkedList<ColumnMetaData> newColumnMetaDataList = new LinkedList<ColumnMetaData>();
        int position = 0;
        List<String> columnTypes = createStatement.getColumnTypes();
        List<String> primaryKeyColumns = createStatement.getPrimaryKeyColumns();
        for (String each : createStatement.getColumnNames()) {
            String type = null;
            if (columnTypes.size() > position) {
                type = columnTypes.get(position);
            }
            newColumnMetaDataList.add(new ColumnMetaData(each, type, primaryKeyColumns.contains(each)));
        }
        createStatement.setTableMetaData(new TableMetaData(newColumnMetaDataList));
    }
}

