/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler.impl;

import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.sql.segment.SQLSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.table.TableSegment;
import io.shardingsphere.core.parsing.parser.context.table.Table;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.TableToken;
import io.shardingsphere.core.rule.ShardingRule;

public final class TableFiller
implements SQLStatementFiller {
    @Override
    public void fill(SQLSegment sqlSegment, SQLStatement sqlStatement, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        TableSegment tableSegment = (TableSegment)sqlSegment;
        String tableName = tableSegment.getName();
        boolean needAdd = false;
        if (!(sqlStatement instanceof SelectStatement)) {
            needAdd = true;
        } else if (shardingRule.tryFindTableRuleByLogicTable(tableName).isPresent() || shardingRule.isBroadcastTable(tableName) || shardingRule.findBindingTableRule(tableName).isPresent() || shardingRule.getShardingDataSourceNames().getDataSourceNames().contains(shardingRule.getShardingDataSourceNames().getDefaultDataSourceName())) {
            needAdd = true;
        }
        if (!needAdd) {
            return;
        }
        sqlStatement.getTables().add(new Table(tableSegment.getName(), tableSegment.getAlias()));
        sqlStatement.getSQLTokens().add(tableSegment.getToken());
        if (!tableSegment.getAlias().isPresent()) {
            return;
        }
        if (sqlStatement.getTables().getTableNames().contains(tableSegment.getAlias().get())) {
            sqlStatement.addSQLToken(new TableToken(tableSegment.getAliasStartPosition(), 0, (String)tableSegment.getAlias().get()));
        }
    }
}

