/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler.impl;

import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.sql.segment.SQLSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.OrderByItemSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.OrderBySegment;
import io.shardingsphere.core.parsing.parser.context.OrderItem;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.TableToken;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.SQLUtil;

public final class OrderByFiller
implements SQLStatementFiller {
    @Override
    public void fill(SQLSegment sqlSegment, SQLStatement sqlStatement, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        OrderBySegment orderBySegment = (OrderBySegment)sqlSegment;
        SelectStatement selectStatement = (SelectStatement)sqlStatement;
        if (!selectStatement.getSubQueryStatements().isEmpty()) {
            return;
        }
        for (OrderByItemSegment each : orderBySegment.getOrderByItems()) {
            selectStatement.getOrderByItems().add(this.buildOrderItemAndFillToken(selectStatement, each, sql));
        }
    }

    protected OrderItem buildOrderItemAndFillToken(SelectStatement selectStatement, OrderByItemSegment orderByItemSegment, String sql) {
        if (-1 < orderByItemSegment.getIndex()) {
            return new OrderItem(orderByItemSegment.getIndex(), orderByItemSegment.getOrderDirection(), orderByItemSegment.getNullOrderDirection());
        }
        String expression = sql.substring(orderByItemSegment.getExpressionStartPosition(), orderByItemSegment.getExpressionEndPosition() + 1);
        if (!orderByItemSegment.isIdentifier()) {
            return new OrderItem(expression, orderByItemSegment.getOrderDirection(), orderByItemSegment.getNullOrderDirection(), selectStatement.getAlias(expression));
        }
        expression = SQLUtil.getExactlyValue(expression);
        int dotPosition = expression.indexOf(".");
        String name = expression;
        if (0 < dotPosition) {
            name = expression.substring(dotPosition + 1);
            String owner = expression.substring(0, dotPosition);
            if (selectStatement.getTables().getTableNames().contains(owner)) {
                selectStatement.addSQLToken(new TableToken(orderByItemSegment.getExpressionStartPosition(), 0, owner));
            }
            return new OrderItem(owner, name, orderByItemSegment.getOrderDirection(), orderByItemSegment.getNullOrderDirection(), selectStatement.getAlias(owner + "." + name));
        }
        return new OrderItem(name, orderByItemSegment.getOrderDirection(), orderByItemSegment.getNullOrderDirection(), selectStatement.getAlias(name));
    }
}

