/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.sql.segment.SQLSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.constraint.ConstraintDefinitionSegment;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.AlterTableStatement;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.ColumnDefinition;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.ddl.create.table.CreateTableStatement;
import io.shardingsphere.core.rule.ShardingRule;

public final class ConstraintDefinitionFiller
implements SQLStatementFiller {
    @Override
    public void fill(SQLSegment sqlSegment, SQLStatement sqlStatement, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        if (sqlStatement instanceof AlterTableStatement) {
            this.fillAlter((ConstraintDefinitionSegment)sqlSegment, (AlterTableStatement)sqlStatement, shardingTableMetaData);
        } else if (sqlStatement instanceof CreateTableStatement) {
            this.fillCreate((ConstraintDefinitionSegment)sqlSegment, (CreateTableStatement)sqlStatement);
        }
    }

    private void fillAlter(ConstraintDefinitionSegment constraintDefinitionSegment, AlterTableStatement alterTableStatement, ShardingTableMetaData shardingTableMetaData) {
        for (String each : constraintDefinitionSegment.getPrimaryKeyColumnNames()) {
            Optional<ColumnDefinition> updateColumn = alterTableStatement.findColumnDefinition(each, shardingTableMetaData);
            if (!updateColumn.isPresent()) continue;
            ((ColumnDefinition)updateColumn.get()).setPrimaryKey(true);
            alterTableStatement.getUpdateColumns().put(each, (ColumnDefinition)updateColumn.get());
        }
    }

    private void fillCreate(ConstraintDefinitionSegment constraintDefinitionSegment, CreateTableStatement createTableStatement) {
        for (String each : constraintDefinitionSegment.getPrimaryKeyColumnNames()) {
            createTableStatement.getPrimaryKeyColumns().add(each);
        }
    }
}

