/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl.dialect.mysql;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.ColumnDefinitionExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.dialect.mysql.MySQLColumnPositionExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnDefinitionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnPositionSegment;
import org.antlr.v4.runtime.ParserRuleContext;

public final class MySQLChangeColumnExtractor
implements OptionalSQLSegmentExtractor {
    private final ColumnDefinitionExtractor columnDefinitionPhraseExtractor = new ColumnDefinitionExtractor();

    public Optional<ColumnDefinitionSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> changeColumnNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.CHANGE_COLUMN);
        if (!changeColumnNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> oldColumnNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)changeColumnNode.get(), RuleName.COLUMN_NAME);
        if (!oldColumnNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> columnDefinitionNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)changeColumnNode.get(), RuleName.COLUMN_DEFINITION);
        if (!columnDefinitionNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ColumnDefinitionSegment> result = this.columnDefinitionPhraseExtractor.extract((ParserRuleContext)columnDefinitionNode.get());
        if (result.isPresent()) {
            ((ColumnDefinitionSegment)result.get()).setOldName(((ParserRuleContext)oldColumnNode.get()).getText());
            Optional<ColumnPositionSegment> columnPosition = new MySQLColumnPositionExtractor(((ColumnDefinitionSegment)result.get()).getName()).extract((ParserRuleContext)changeColumnNode.get());
            if (columnPosition.isPresent()) {
                ((ColumnDefinitionSegment)result.get()).setPosition((ColumnPositionSegment)columnPosition.get());
            }
        }
        return result;
    }
}

