/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.core.constant.ShardingOperator;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.ColumnSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.ExpressionExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.LogicalOperator;
import io.shardingsphere.core.parsing.antlr.extractor.util.Paren;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.condition.AndConditionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.condition.ConditionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.condition.OrConditionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.condition.PredicateSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.BetweenValueExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.CommonExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.EqualsValueExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.ExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.InValueExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.SQLRightValueExpressionSegment;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.util.NumberUtil;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;

public final class PredicateExtractor
implements OptionalSQLSegmentExtractor {
    private final Map<String, String> tableAlias;

    public Optional<PredicateSegment> extract(ParserRuleContext ancestorNode) {
        throw new RuntimeException();
    }

    public Optional<OrConditionSegment> extractCondition(Map<ParserRuleContext, Integer> questionNodeIndexMap, ParserRuleContext exprNode) {
        int index = -1;
        for (int i = 0; i < exprNode.getChildCount(); ++i) {
            if (!LogicalOperator.isLogicalOperator(exprNode.getChild(i).getText())) continue;
            index = i;
            break;
        }
        if (index > 0) {
            Optional<OrConditionSegment> leftOrCondition = this.extractCondition(questionNodeIndexMap, (ParserRuleContext)exprNode.getChild(index - 1));
            Optional<OrConditionSegment> rightOrCondition = this.extractCondition(questionNodeIndexMap, (ParserRuleContext)exprNode.getChild(index + 1));
            return this.mergeCondition(leftOrCondition, rightOrCondition, exprNode.getChild(index).getText());
        }
        return this.extractConditionForParen(questionNodeIndexMap, exprNode);
    }

    private Optional<OrConditionSegment> mergeCondition(Optional<OrConditionSegment> leftOrCondition, Optional<OrConditionSegment> rightOrCondition, String operator) {
        if (!leftOrCondition.isPresent() && !rightOrCondition.isPresent()) {
            return Optional.absent();
        }
        if (leftOrCondition.isPresent() && !rightOrCondition.isPresent()) {
            return leftOrCondition;
        }
        if (rightOrCondition.isPresent() && !leftOrCondition.isPresent()) {
            return rightOrCondition;
        }
        if (LogicalOperator.isOrOperator(operator)) {
            ((OrConditionSegment)leftOrCondition.get()).getAndConditions().addAll(((OrConditionSegment)rightOrCondition.get()).getAndConditions());
            return leftOrCondition;
        }
        OrConditionSegment result = new OrConditionSegment();
        for (AndConditionSegment each : ((OrConditionSegment)leftOrCondition.get()).getAndConditions()) {
            for (AndConditionSegment eachRightOr : ((OrConditionSegment)rightOrCondition.get()).getAndConditions()) {
                AndConditionSegment tempList = new AndConditionSegment();
                tempList.getConditions().addAll(each.getConditions());
                tempList.getConditions().addAll(eachRightOr.getConditions());
                result.getAndConditions().add(tempList);
            }
        }
        return Optional.of((Object)result);
    }

    private Optional<OrConditionSegment> extractConditionForParen(Map<ParserRuleContext, Integer> questionNodeIndexMap, ParserRuleContext exprNode) {
        int index = -1;
        for (int i = 0; i < exprNode.getChildCount(); ++i) {
            if (!Paren.isLeftParen(exprNode.getChild(i).getText())) continue;
            index = i;
            break;
        }
        if (-1 != index) {
            Preconditions.checkState((boolean)Paren.match(exprNode.getChild(index).getText(), exprNode.getChild(index + 2).getText()), (Object)"Missing right paren.");
            if (RuleName.EXPR.getName().equals(exprNode.getChild(index + 1).getClass().getSimpleName())) {
                return this.extractCondition(questionNodeIndexMap, (ParserRuleContext)exprNode.getChild(index + 1));
            }
            return Optional.absent();
        }
        Optional<ConditionSegment> condition = this.buildCondition(questionNodeIndexMap, exprNode);
        if (condition.isPresent()) {
            OrConditionSegment result = new OrConditionSegment();
            AndConditionSegment newAndCondition = new AndConditionSegment();
            newAndCondition.getConditions().add((ConditionSegment)condition.get());
            result.getAndConditions().add(newAndCondition);
            return Optional.of((Object)result);
        }
        return Optional.absent();
    }

    private Optional<ConditionSegment> buildCondition(Map<ParserRuleContext, Integer> questionNodeIndexMap, ParserRuleContext exprNode) {
        Optional<ConditionSegment> result = this.buildEqualCondition(questionNodeIndexMap, exprNode);
        if (result.isPresent()) {
            return result;
        }
        return this.buildPredicateCondition(questionNodeIndexMap, exprNode);
    }

    private Optional<ConditionSegment> buildEqualCondition(Map<ParserRuleContext, Integer> questionNodeIndexMap, ParserRuleContext exprNode) {
        Optional<ParserRuleContext> comparisionNode = ExtractorUtils.findFirstChildNode(exprNode, RuleName.COMPARISON_OPERATOR);
        if (!comparisionNode.isPresent()) {
            return Optional.absent();
        }
        if (!Symbol.EQ.getLiterals().equalsIgnoreCase(((ParserRuleContext)comparisionNode.get()).getText())) {
            return Optional.absent();
        }
        if (3 != ((ParserRuleContext)comparisionNode.get()).getParent().getChildCount()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> leftNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)((ParserRuleContext)comparisionNode.get()).parent.getChild(0), RuleName.COLUMN_NAME);
        Optional<ParserRuleContext> rightNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)((ParserRuleContext)comparisionNode.get()).parent.getChild(2), RuleName.COLUMN_NAME);
        if (!leftNode.isPresent() && !rightNode.isPresent()) {
            return Optional.absent();
        }
        if (leftNode.isPresent() && rightNode.isPresent()) {
            Optional<ColumnSegment> column = this.buildColumn((ParserRuleContext)leftNode.get());
            Optional<ColumnSegment> rightColumn = this.buildColumn((ParserRuleContext)rightNode.get());
            return Optional.of((Object)new ConditionSegment((ColumnSegment)column.get(), ShardingOperator.EQUAL, (SQLRightValueExpressionSegment)rightColumn.get()));
        }
        Optional<ColumnSegment> column = this.buildColumn(exprNode);
        ParserRuleContext valueNode = leftNode.isPresent() ? (ParserRuleContext)((ParserRuleContext)comparisionNode.get()).parent.getChild(2) : (ParserRuleContext)((ParserRuleContext)comparisionNode.get()).parent.getChild(0);
        Optional<ExpressionSegment> sqlExpression = this.buildExpression(questionNodeIndexMap, valueNode);
        if (!sqlExpression.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)new ConditionSegment((ColumnSegment)column.get(), ShardingOperator.EQUAL, new EqualsValueExpressionSegment((ExpressionSegment)sqlExpression.get())));
    }

    private Optional<ExpressionSegment> buildExpression(Map<ParserRuleContext, Integer> questionNodeIndexMap, ParserRuleContext valueNode) {
        Optional<ExpressionSegment> sqlExpression = new ExpressionExtractor().extract(valueNode);
        if (!sqlExpression.isPresent() || !(sqlExpression.get() instanceof CommonExpressionSegment)) {
            return sqlExpression;
        }
        CommonExpressionSegment commonExpressionSegment = (CommonExpressionSegment)sqlExpression.get();
        Optional<ParserRuleContext> expressionNode = ExtractorUtils.findFirstChildNode(valueNode, RuleName.QUESTION);
        if (expressionNode.isPresent()) {
            Integer index = questionNodeIndexMap.get(expressionNode.get());
            commonExpressionSegment.setIndex(index);
        } else {
            Optional<ParserRuleContext> bitExprNode = ExtractorUtils.findFirstChildNode(valueNode, RuleName.BITEXPR);
            expressionNode = ExtractorUtils.findFirstChildNode(valueNode, RuleName.NUMBER);
            if (expressionNode.isPresent() && (!bitExprNode.isPresent() || 1 == ((ParserRuleContext)bitExprNode.get()).getChildCount())) {
                commonExpressionSegment.setValue(NumberUtil.getExactlyNumber(((ParserRuleContext)expressionNode.get()).getText(), 10));
            }
        }
        return sqlExpression;
    }

    private Optional<ConditionSegment> buildPredicateCondition(Map<ParserRuleContext, Integer> questionNodeIndexMap, ParserRuleContext exprNode) {
        Optional<ConditionSegment> result;
        Optional<ParserRuleContext> predicateNode = ExtractorUtils.findFirstChildNode(exprNode, RuleName.PREDICATE);
        if (!predicateNode.isPresent()) {
            return Optional.absent();
        }
        if (1 != ((ParserRuleContext)predicateNode.get()).getParent().getChildCount()) {
            return Optional.absent();
        }
        if (5 == ((ParserRuleContext)predicateNode.get()).getChildCount() && DefaultKeyword.BETWEEN.name().equalsIgnoreCase(((ParserRuleContext)predicateNode.get()).getChild(1).getText()) && (result = this.buildBetweenCondition(questionNodeIndexMap, (ParserRuleContext)predicateNode.get())).isPresent()) {
            return result;
        }
        if (5 <= ((ParserRuleContext)predicateNode.get()).getChildCount() && DefaultKeyword.IN.name().equalsIgnoreCase(((ParserRuleContext)predicateNode.get()).getChild(1).getText()) && (result = this.buildInCondition(questionNodeIndexMap, (ParserRuleContext)predicateNode.get())).isPresent()) {
            return result;
        }
        return Optional.absent();
    }

    private Optional<ConditionSegment> buildBetweenCondition(Map<ParserRuleContext, Integer> questionNodeIndexMap, ParserRuleContext predicateNode) {
        Optional<ColumnSegment> column = this.buildColumn((ParserRuleContext)predicateNode.getChild(0));
        if (!column.isPresent()) {
            return Optional.absent();
        }
        Optional<ExpressionSegment> beginSQLExpression = this.buildExpression(questionNodeIndexMap, (ParserRuleContext)predicateNode.getChild(2));
        Optional<ExpressionSegment> endSQLExpression = this.buildExpression(questionNodeIndexMap, (ParserRuleContext)predicateNode.getChild(4));
        if (beginSQLExpression.isPresent() && endSQLExpression.isPresent()) {
            return Optional.of((Object)new ConditionSegment((ColumnSegment)column.get(), ShardingOperator.BETWEEN, new BetweenValueExpressionSegment((ExpressionSegment)beginSQLExpression.get(), (ExpressionSegment)endSQLExpression.get())));
        }
        return Optional.absent();
    }

    private Optional<ConditionSegment> buildInCondition(Map<ParserRuleContext, Integer> questionNodeIndexMap, ParserRuleContext predicateNode) {
        Optional<ColumnSegment> column = this.buildColumn((ParserRuleContext)predicateNode.getChild(0));
        if (!column.isPresent()) {
            return Optional.absent();
        }
        LinkedList<Object> sqlExpressions = new LinkedList<Object>();
        for (int i = 3; i < predicateNode.getChildCount(); ++i) {
            if (!RuleName.SIMPLE_EXPR.getName().equals(predicateNode.getChild(i).getClass().getSimpleName())) continue;
            Optional<ExpressionSegment> expression = this.buildExpression(questionNodeIndexMap, (ParserRuleContext)predicateNode.getChild(i));
            if (!expression.isPresent()) {
                sqlExpressions.clear();
                break;
            }
            sqlExpressions.add(expression.get());
        }
        if (!sqlExpressions.isEmpty()) {
            InValueExpressionSegment inExpressionSegment = new InValueExpressionSegment();
            inExpressionSegment.getSqlExpressions().addAll(sqlExpressions);
            return Optional.of((Object)new ConditionSegment((ColumnSegment)column.get(), ShardingOperator.IN, inExpressionSegment));
        }
        return Optional.absent();
    }

    private Optional<ColumnSegment> buildColumn(ParserRuleContext parentNode) {
        return new ColumnSegmentExtractor(this.tableAlias).extract(parentNode);
    }

    @ConstructorProperties(value={"tableAlias"})
    public PredicateExtractor(Map<String, String> tableAlias) {
        this.tableAlias = tableAlias;
    }
}

