/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.LimitSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.LimitValueSegment;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.util.NumberUtil;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;

public final class LimitExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<LimitSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> limitNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.LIMIT_CLAUSE);
        if (!limitNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> rangeNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)limitNode.get(), RuleName.RANGE_CLAUSE);
        if (!rangeNode.isPresent()) {
            return Optional.absent();
        }
        Map<ParserRuleContext, Integer> placeholderAndNodeIndexMap = this.getPlaceholderAndNodeIndexMap(ancestorNode);
        LimitValueSegment firstLimitValue = this.createLimitValueSegment(placeholderAndNodeIndexMap, (ParserRuleContext)((ParserRuleContext)rangeNode.get()).getChild(0));
        Preconditions.checkNotNull((Object)firstLimitValue);
        if (((ParserRuleContext)rangeNode.get()).getChildCount() >= 3) {
            LimitValueSegment rowCountLimitValue = this.createLimitValueSegment(placeholderAndNodeIndexMap, (ParserRuleContext)((ParserRuleContext)rangeNode.get()).getChild(2));
            return Optional.of((Object)new LimitSegment(DatabaseType.MySQL, rowCountLimitValue, (Optional<LimitValueSegment>)Optional.of((Object)firstLimitValue)));
        }
        return Optional.of((Object)new LimitSegment(DatabaseType.MySQL, firstLimitValue));
    }

    private Map<ParserRuleContext, Integer> getPlaceholderAndNodeIndexMap(ParserRuleContext ancestorNode) {
        HashMap<ParserRuleContext, Integer> result = new HashMap<ParserRuleContext, Integer>();
        int index = 0;
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.QUESTION)) {
            result.put(each, index++);
        }
        return result;
    }

    private LimitValueSegment createLimitValueSegment(Map<ParserRuleContext, Integer> placeholderAndNodeIndexMap, ParserRuleContext node) {
        if (node.getText().equals(Symbol.QUESTION.getLiterals())) {
            return new LimitValueSegment(-1, placeholderAndNodeIndexMap.get(node.getChild(0)), ((ParserRuleContext)node.getChild(0)).getStart().getStartIndex());
        }
        return new LimitValueSegment(NumberUtil.getExactlyNumber(node.getText(), 10).intValue(), -1, node.getStart().getStartIndex());
    }
}

