/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.PredicateExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.SubqueryExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.TableNameExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.FromWhereSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.condition.OrConditionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.SubquerySegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.table.TableJoinSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.table.TableSegment;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class FromWhereExtractor
implements OptionalSQLSegmentExtractor {
    private final TableNameExtractor tableNameExtractor = new TableNameExtractor();
    private PredicateExtractor predicateSegmentExtractor;

    public Optional<FromWhereSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> selectClauseNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.SELECT_CLAUSE);
        if (!selectClauseNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> fromNode = ExtractorUtils.findFirstChildNodeNoneRecursive(((ParserRuleContext)selectClauseNode.get()).getParent(), RuleName.FROM_CLAUSE);
        if (!fromNode.isPresent()) {
            return Optional.absent();
        }
        Collection<ParserRuleContext> tableReferenceNodes = ExtractorUtils.getAllDescendantNodes((ParserRuleContext)fromNode.get(), RuleName.TABLE_REFERENCE);
        if (tableReferenceNodes.isEmpty()) {
            return Optional.absent();
        }
        FromWhereSegment result = new FromWhereSegment();
        this.predicateSegmentExtractor = new PredicateExtractor(result.getTableAliases());
        Collection<ParserRuleContext> questionNodes = ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.QUESTION);
        result.setParameterCount(questionNodes.size());
        HashMap<ParserRuleContext, Integer> questionNodeIndexMap = new HashMap<ParserRuleContext, Integer>();
        int index = 0;
        for (ParserRuleContext each : questionNodes) {
            questionNodeIndexMap.put(each, index++);
        }
        this.extractAndFillTableSegment(result, tableReferenceNodes, questionNodeIndexMap);
        this.extractAndFillWhere(result, questionNodeIndexMap, ((ParserRuleContext)fromNode.get()).getParent());
        return Optional.of((Object)result);
    }

    private void extractAndFillTableSegment(FromWhereSegment fromWhereSegment, Collection<ParserRuleContext> tableReferenceNodes, Map<ParserRuleContext, Integer> questionNodeIndexMap) {
        for (ParserRuleContext each : tableReferenceNodes) {
            for (int i = 0; i < each.getChildCount(); ++i) {
                if (each.getChild(i) instanceof TerminalNode) continue;
                ParserRuleContext childNode = (ParserRuleContext)each.getChild(i);
                if (RuleName.TABLE_REFERENCES.getName().equals(childNode.getClass().getSimpleName())) {
                    Collection<ParserRuleContext> subTableReferenceNodes = ExtractorUtils.getAllDescendantNodes(childNode, RuleName.TABLE_REFERENCE);
                    if (subTableReferenceNodes.isEmpty()) continue;
                    this.extractAndFillTableSegment(fromWhereSegment, subTableReferenceNodes, questionNodeIndexMap);
                    continue;
                }
                if (RuleName.TABLE_FACTOR.getName().equals(childNode.getClass().getSimpleName()) && this.fillSubquery(fromWhereSegment, childNode)) continue;
                this.fillTable(fromWhereSegment, childNode, questionNodeIndexMap);
            }
        }
    }

    private boolean fillSubquery(FromWhereSegment fromWhereSegment, ParserRuleContext tableFactorNode) {
        Optional<ParserRuleContext> subqueryNode = ExtractorUtils.findFirstChildNode(tableFactorNode, RuleName.SUBQUERY);
        if (!subqueryNode.isPresent()) {
            return false;
        }
        Optional<SubquerySegment> result = new SubqueryExtractor().extract((ParserRuleContext)subqueryNode.get());
        if (result.isPresent()) {
            fromWhereSegment.getSubquerys().add((SubquerySegment)result.get());
        }
        return true;
    }

    private void fillTable(FromWhereSegment fromWhereSegment, ParserRuleContext joinOrTableFactorNode, Map<ParserRuleContext, Integer> questionNodeIndexMap) {
        Optional<ParserRuleContext> joinConditionNode;
        if (!RuleName.JOIN_TABLE.getName().endsWith(joinOrTableFactorNode.getClass().getSimpleName())) {
            Optional<TableSegment> tableSegment = this.tableNameExtractor.extract(joinOrTableFactorNode);
            this.fillTableResult(fromWhereSegment, (TableSegment)tableSegment.get());
        }
        if ((joinConditionNode = ExtractorUtils.findFirstChildNode(joinOrTableFactorNode, RuleName.JOIN_CONDITION)).isPresent()) {
            ParserRuleContext tableFactorNode = (ParserRuleContext)ExtractorUtils.findFirstChildNode(joinOrTableFactorNode, RuleName.TABLE_FACTOR).get();
            Optional<TableSegment> tableSegment = this.tableNameExtractor.extract(tableFactorNode);
            TableJoinSegment tableJoinResult = new TableJoinSegment((TableSegment)tableSegment.get());
            Optional<OrConditionSegment> conditionResult = this.buildCondition((ParserRuleContext)joinConditionNode.get(), questionNodeIndexMap, fromWhereSegment.getTableAliases());
            if (conditionResult.isPresent()) {
                tableJoinResult.getJoinConditions().getAndConditions().addAll(((OrConditionSegment)conditionResult.get()).getAndConditions());
                fromWhereSegment.getConditions().getAndConditions().addAll(((OrConditionSegment)conditionResult.get()).getAndConditions());
            }
            this.fillTableResult(fromWhereSegment, tableJoinResult);
        }
    }

    private void fillTableResult(FromWhereSegment fromWhereSegment, TableSegment tableSegment) {
        String alias = tableSegment.getName();
        if (tableSegment.getAlias().isPresent()) {
            alias = (String)tableSegment.getAlias().get();
        }
        fromWhereSegment.getTableAliases().put(alias, tableSegment.getName());
    }

    private Optional<OrConditionSegment> buildCondition(ParserRuleContext node, Map<ParserRuleContext, Integer> questionNodeIndexMap, Map<String, String> tableAliases) {
        Optional<ParserRuleContext> exprNode = ExtractorUtils.findFirstChildNode(node, RuleName.EXPR);
        if (exprNode.isPresent()) {
            return this.predicateSegmentExtractor.extractCondition(questionNodeIndexMap, (ParserRuleContext)exprNode.get());
        }
        return Optional.absent();
    }

    private void extractAndFillWhere(FromWhereSegment fromWhereSegment, Map<ParserRuleContext, Integer> questionNodeIndexMap, ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> whereNode = ExtractorUtils.findFirstChildNodeNoneRecursive(ancestorNode, RuleName.WHERE_CLAUSE);
        if (!whereNode.isPresent()) {
            return;
        }
        Optional<OrConditionSegment> conditions = this.buildCondition((ParserRuleContext)((ParserRuleContext)whereNode.get()).getChild(1), questionNodeIndexMap, fromWhereSegment.getTableAliases());
        if (conditions.isPresent()) {
            fromWhereSegment.getConditions().getAndConditions().addAll(((OrConditionSegment)conditions.get()).getAndConditions());
        }
    }
}

