/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataInitializer;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.Map;

public final class ShardingMetaData {
    private final ShardingDataSourceMetaData dataSource;
    private final ShardingTableMetaData table;

    public ShardingMetaData(Map<String, String> dataSourceURLs, ShardingRule shardingRule, DatabaseType databaseType, ShardingExecuteEngine executeEngine, TableMetaDataConnectionManager connectionManager, int maxConnectionsSizePerQuery) {
        this.dataSource = new ShardingDataSourceMetaData(dataSourceURLs, shardingRule, databaseType);
        this.table = new ShardingTableMetaData(new TableMetaDataInitializer(this.dataSource, executeEngine, connectionManager, maxConnectionsSizePerQuery).load(shardingRule));
    }

    public ShardingDataSourceMetaData getDataSource() {
        return this.dataSource;
    }

    public ShardingTableMetaData getTable() {
        return this.table;
    }
}

