/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dql;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.executor.sql.execute.result.AggregationDistinctQueryResult;
import io.shardingsphere.core.executor.sql.execute.result.DistinctQueryResult;
import io.shardingsphere.core.merger.MergeEngine;
import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.merger.dql.groupby.GroupByMemoryMergedResult;
import io.shardingsphere.core.merger.dql.groupby.GroupByStreamMergedResult;
import io.shardingsphere.core.merger.dql.iterator.IteratorStreamMergedResult;
import io.shardingsphere.core.merger.dql.orderby.OrderByStreamMergedResult;
import io.shardingsphere.core.merger.dql.pagination.LimitDecoratorMergedResult;
import io.shardingsphere.core.merger.dql.pagination.RowNumberDecoratorMergedResult;
import io.shardingsphere.core.merger.dql.pagination.TopAndRowNumberDecoratorMergedResult;
import io.shardingsphere.core.parsing.parser.context.limit.Limit;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.util.SQLUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class DQLMergeEngine
implements MergeEngine {
    private final SelectStatement selectStatement;
    private final List<QueryResult> queryResults;
    private final Map<String, Integer> columnLabelIndexMap;

    public DQLMergeEngine(List<QueryResult> queryResults, SelectStatement selectStatement) throws SQLException {
        this.selectStatement = selectStatement;
        List<QueryResult> realQueryResult = this.getRealQueryResults(queryResults);
        this.queryResults = !realQueryResult.isEmpty() ? realQueryResult : queryResults;
        this.columnLabelIndexMap = this.getColumnLabelIndexMap(this.queryResults.get(0));
    }

    private List<QueryResult> getRealQueryResults(List<QueryResult> queryResults) {
        if (!this.selectStatement.getAggregationDistinctSelectItems().isEmpty()) {
            return this.getDividedQueryResults(new AggregationDistinctQueryResult(queryResults, this.selectStatement));
        }
        if (!this.selectStatement.getDistinctSelectItems().isEmpty()) {
            return this.getDividedQueryResults(new DistinctQueryResult(queryResults, new ArrayList<String>(this.selectStatement.getDistinctSelectItems().get(0).getDistinctColumnLabels())));
        }
        return queryResults;
    }

    private List<QueryResult> getDividedQueryResults(DistinctQueryResult distinctQueryResult) {
        return Lists.transform(distinctQueryResult.divide(), (Function)new Function<DistinctQueryResult, QueryResult>(){

            public QueryResult apply(DistinctQueryResult input) {
                return input;
            }
        });
    }

    private Map<String, Integer> getColumnLabelIndexMap(QueryResult queryResult) throws SQLException {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 1; i <= queryResult.getColumnCount(); ++i) {
            result.put(SQLUtil.getExactlyValue(queryResult.getColumnLabel(i)), i);
        }
        return result;
    }

    @Override
    public MergedResult merge() throws SQLException {
        this.selectStatement.setIndexForItems(this.columnLabelIndexMap);
        return this.decorate(this.build());
    }

    private MergedResult build() throws SQLException {
        if (!this.selectStatement.getGroupByItems().isEmpty() || !this.selectStatement.getAggregationSelectItems().isEmpty()) {
            return this.getGroupByMergedResult();
        }
        if (!this.selectStatement.getOrderByItems().isEmpty()) {
            return new OrderByStreamMergedResult(this.queryResults, this.selectStatement.getOrderByItems());
        }
        return new IteratorStreamMergedResult(this.queryResults);
    }

    private MergedResult getGroupByMergedResult() throws SQLException {
        if (this.selectStatement.isSameGroupByAndOrderByItems()) {
            return new GroupByStreamMergedResult(this.columnLabelIndexMap, this.queryResults, this.selectStatement);
        }
        return new GroupByMemoryMergedResult(this.columnLabelIndexMap, this.queryResults, this.selectStatement);
    }

    private MergedResult decorate(MergedResult mergedResult) throws SQLException {
        Limit limit = this.selectStatement.getLimit();
        if (null == limit || 1 == this.queryResults.size()) {
            return mergedResult;
        }
        if (DatabaseType.MySQL == limit.getDatabaseType() || DatabaseType.PostgreSQL == limit.getDatabaseType() || DatabaseType.H2 == limit.getDatabaseType()) {
            return new LimitDecoratorMergedResult(mergedResult, this.selectStatement.getLimit());
        }
        if (DatabaseType.Oracle == limit.getDatabaseType()) {
            return new RowNumberDecoratorMergedResult(mergedResult, this.selectStatement.getLimit());
        }
        if (DatabaseType.SQLServer == limit.getDatabaseType()) {
            return new TopAndRowNumberDecoratorMergedResult(mergedResult, this.selectStatement.getLimit());
        }
        return mergedResult;
    }
}

