/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.keygen;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.keygen.KeyGenerator;
import io.shardingsphere.core.keygen.TimeService;
import java.util.Calendar;

public final class DefaultKeyGenerator
implements KeyGenerator {
    public static final long EPOCH;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final long WORKER_ID_LEFT_SHIFT_BITS = 12L;
    private static final long TIMESTAMP_LEFT_SHIFT_BITS = 22L;
    private static final long WORKER_ID_MAX_VALUE = 1024L;
    private static TimeService timeService;
    private static long workerId;
    private static int maxTolerateTimeDifferenceMilliseconds;
    private byte sequenceOffset;
    private long sequence;
    private long lastMilliseconds;

    public static void setWorkerId(long workerId) {
        Preconditions.checkArgument((workerId >= 0L && workerId < 1024L ? 1 : 0) != 0);
        DefaultKeyGenerator.workerId = workerId;
    }

    public static void setMaxTolerateTimeDifferenceMilliseconds(int maxTolerateTimeDifferenceMilliseconds) {
        DefaultKeyGenerator.maxTolerateTimeDifferenceMilliseconds = maxTolerateTimeDifferenceMilliseconds;
    }

    @Override
    public synchronized Number generateKey() {
        long currentMilliseconds = timeService.getCurrentMillis();
        if (this.waitTolerateTimeDifferenceIfNeed(currentMilliseconds)) {
            currentMilliseconds = timeService.getCurrentMillis();
        }
        if (this.lastMilliseconds == currentMilliseconds) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (0L == this.sequence) {
                currentMilliseconds = this.waitUntilNextTime(currentMilliseconds);
            }
        } else {
            this.vibrateSequenceOffset();
            this.sequence = this.sequenceOffset;
        }
        this.lastMilliseconds = currentMilliseconds;
        return currentMilliseconds - EPOCH << 22 | workerId << 12 | this.sequence;
    }

    private boolean waitTolerateTimeDifferenceIfNeed(long currentMilliseconds) {
        if (this.lastMilliseconds <= currentMilliseconds) {
            return false;
        }
        long timeDifferenceMilliseconds = this.lastMilliseconds - currentMilliseconds;
        Preconditions.checkState((timeDifferenceMilliseconds > (long)maxTolerateTimeDifferenceMilliseconds ? 1 : 0) != 0, (String)"Clock is moving backwards, last time is %d milliseconds, current time is %d milliseconds", (Object[])new Object[]{this.lastMilliseconds, currentMilliseconds});
        Thread.sleep(timeDifferenceMilliseconds);
        return true;
    }

    private long waitUntilNextTime(long lastTime) {
        long result = timeService.getCurrentMillis();
        while (result <= lastTime) {
            result = timeService.getCurrentMillis();
        }
        return result;
    }

    private void vibrateSequenceOffset() {
        this.sequenceOffset = (byte)(~this.sequenceOffset & 1);
    }

    public static void setTimeService(TimeService timeService) {
        DefaultKeyGenerator.timeService = timeService;
    }

    static {
        timeService = new TimeService();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 10, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        EPOCH = calendar.getTimeInMillis();
    }
}

