/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute.result;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import io.shardingsphere.core.constant.AggregationType;
import io.shardingsphere.core.executor.sql.execute.result.DistinctQueryResult;
import io.shardingsphere.core.executor.sql.execute.row.QueryRow;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationDistinctSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationSelectItem;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class AggregationDistinctQueryResult
extends DistinctQueryResult {
    private final Multimap<String, Integer> distinctAggregationColumnLabelAndIndexes = HashMultimap.create();
    private final Map<Integer, AggregationType> distinctAggregationIndexAndTypes = new LinkedHashMap<Integer, AggregationType>();
    private final Map<Integer, Integer> derivedCountIndexAndDistinctIndexes = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, Integer> derivedSumIndexAndDistinctIndexes = new LinkedHashMap<Integer, Integer>();

    private AggregationDistinctQueryResult(Multimap<String, Integer> columnLabelAndIndexMap, Iterator<QueryRow> resultData, Multimap<String, Integer> distinctAggregationColumnLabelAndIndexes, Map<Integer, AggregationType> distinctAggregationIndexAndTypes, Map<Integer, Integer> derivedCountIndexAndDistinctIndexes, Map<Integer, Integer> derivedSumIndexAndDistinctIndexes) {
        super(columnLabelAndIndexMap, resultData);
        this.distinctAggregationColumnLabelAndIndexes.putAll(distinctAggregationColumnLabelAndIndexes);
        this.distinctAggregationIndexAndTypes.putAll(distinctAggregationIndexAndTypes);
        this.derivedCountIndexAndDistinctIndexes.putAll(derivedCountIndexAndDistinctIndexes);
        this.derivedSumIndexAndDistinctIndexes.putAll(derivedSumIndexAndDistinctIndexes);
    }

    public AggregationDistinctQueryResult(Collection<QueryResult> queryResults, SelectStatement selectStatement) {
        super(queryResults, Lists.transform(selectStatement.getAggregationDistinctSelectItems(), (Function)new Function<AggregationDistinctSelectItem, String>(){

            public String apply(AggregationDistinctSelectItem input) {
                return input.getDistinctColumnLabel();
            }
        }));
        this.init(selectStatement);
    }

    private void init(SelectStatement selectStatement) {
        for (AggregationDistinctSelectItem each : selectStatement.getAggregationDistinctSelectItems()) {
            this.distinctAggregationColumnLabelAndIndexes.put((Object)each.getColumnLabel(), (Object)super.getColumnIndex(each.getDistinctColumnLabel()));
            this.initDerivedIndexAndDistinctIndexes(each);
            this.distinctAggregationIndexAndTypes.put(this.getColumnIndex(each.getColumnLabel()), each.getType());
        }
    }

    private void initDerivedIndexAndDistinctIndexes(AggregationDistinctSelectItem selectItem) {
        List<AggregationSelectItem> derivedAggregationSelectItems = selectItem.getDerivedAggregationSelectItems();
        if (!derivedAggregationSelectItems.isEmpty()) {
            this.derivedCountIndexAndDistinctIndexes.put(super.getColumnIndex(derivedAggregationSelectItems.get(0).getColumnLabel()), super.getColumnIndex(selectItem.getDistinctColumnLabel()));
            this.derivedSumIndexAndDistinctIndexes.put(super.getColumnIndex(derivedAggregationSelectItems.get(1).getColumnLabel()), super.getColumnIndex(selectItem.getDistinctColumnLabel()));
        }
    }

    @Override
    public List<DistinctQueryResult> divide() {
        return Lists.newArrayList((Iterator)Iterators.transform(this.getResultData(), (Function)new Function<QueryRow, DistinctQueryResult>(){

            public DistinctQueryResult apply(QueryRow input) {
                LinkedHashSet<QueryRow> resultData = new LinkedHashSet<QueryRow>();
                resultData.add(input);
                return new AggregationDistinctQueryResult(AggregationDistinctQueryResult.this.getColumnLabelAndIndexMap(), resultData.iterator(), AggregationDistinctQueryResult.this.distinctAggregationColumnLabelAndIndexes, AggregationDistinctQueryResult.this.distinctAggregationIndexAndTypes, AggregationDistinctQueryResult.this.derivedCountIndexAndDistinctIndexes, AggregationDistinctQueryResult.this.derivedSumIndexAndDistinctIndexes);
            }
        }));
    }

    private Object getValue(int columnIndex) {
        if (this.distinctAggregationIndexAndTypes.keySet().contains(columnIndex)) {
            return AggregationType.COUNT == this.distinctAggregationIndexAndTypes.get(columnIndex) ? Integer.valueOf(1) : super.getValue(columnIndex, Object.class);
        }
        if (this.derivedCountIndexAndDistinctIndexes.keySet().contains(columnIndex)) {
            return 1;
        }
        if (this.derivedSumIndexAndDistinctIndexes.keySet().contains(columnIndex)) {
            return super.getValue(this.derivedSumIndexAndDistinctIndexes.get(columnIndex), Object.class);
        }
        return super.getValue(columnIndex, Object.class);
    }

    private Object getValue(String columnLabel) {
        return this.getValue(this.getColumnIndex(columnLabel));
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) {
        return this.getValue(columnIndex);
    }

    @Override
    public Object getValue(String columnLabel, Class<?> type) {
        return this.getValue(columnLabel);
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        return this.getValue(columnIndex);
    }

    @Override
    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) {
        return this.getValue(columnLabel);
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) {
        return (InputStream)this.getValue(columnIndex);
    }

    @Override
    public InputStream getInputStream(String columnLabel, String type) {
        return (InputStream)this.getValue(columnLabel);
    }

    @Override
    public boolean wasNull() {
        return null == this.getCurrentRow();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnLabelAndIndexMap().size();
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        for (Map.Entry entry : this.distinctAggregationColumnLabelAndIndexes.entries()) {
            if (columnIndex != (Integer)entry.getValue()) continue;
            return (String)entry.getKey();
        }
        for (Map.Entry entry : this.getColumnLabelAndIndexMap().entries()) {
            if (columnIndex != (Integer)entry.getValue()) continue;
            return (String)entry.getKey();
        }
        throw new SQLException("Column index out of range", "9999");
    }

    @Override
    protected Integer getColumnIndex(String columnLabel) {
        return this.isContainColumnLabel(columnLabel) ? (Integer)new ArrayList(this.distinctAggregationColumnLabelAndIndexes.get((Object)columnLabel)).get(0) : super.getColumnIndex(columnLabel);
    }

    private boolean isContainColumnLabel(String columnLabel) {
        return null != this.distinctAggregationColumnLabelAndIndexes && this.distinctAggregationColumnLabelAndIndexes.containsKey((Object)columnLabel);
    }
}

