/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.guice.impl;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import cucumber.runtime.java.guice.InjectorSource;
import cucumber.runtime.java.guice.impl.InjectorSourceInstantiationFailed;
import cucumber.runtime.java.guice.impl.ScenarioModule;
import cucumber.runtime.java.guice.impl.SequentialScenarioScope;
import java.text.MessageFormat;
import java.util.Properties;

public class InjectorSourceFactory {
    public static final String GUICE_INJECTOR_SOURCE_KEY = "guice.injector-source";
    private final Properties properties;

    public InjectorSourceFactory(Properties properties) {
        this.properties = properties;
    }

    public InjectorSource create() {
        String injectorSourceClassName = this.properties.getProperty(GUICE_INJECTOR_SOURCE_KEY);
        if (injectorSourceClassName == null) {
            return this.createDefaultScenarioModuleInjectorSource();
        }
        return this.instantiateUserSpecifiedInjectorSource(injectorSourceClassName);
    }

    private InjectorSource createDefaultScenarioModuleInjectorSource() {
        return new InjectorSource(){

            @Override
            public Injector getInjector() {
                ScenarioModule scenarioModule = new ScenarioModule(new SequentialScenarioScope());
                return Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{scenarioModule});
            }
        };
    }

    private InjectorSource instantiateUserSpecifiedInjectorSource(String injectorSourceClassName) {
        try {
            return (InjectorSource)Class.forName(injectorSourceClassName).newInstance();
        }
        catch (Exception e) {
            String message = MessageFormat.format("Instantiation of ''{0}'' failed. Checked the caused by exception and ensure yourInjectorSource implementation is accessible and has a public zero args constructor.", injectorSourceClassName);
            throw new InjectorSourceInstantiationFailed(message, e);
        }
    }
}

