/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core.oauth.token;

import com.alibaba.fastjson.annotation.JSONField;
import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.common.util.CheckUtils;
import org.apache.commons.lang3.StringUtils;

public class TokenParameter {
    @JSONField(name="authorize_type")
    private String authorizeType;
    @JSONField(name="client_id")
    private String clientId;
    @JSONField(name="client_secret")
    private String clientSecret;
    @JSONField(name="grant_id")
    private String grantId;
    @JSONField(name="grant_type")
    private String grantType;
    @JSONField(name="code")
    private String code;
    @JSONField(name="refresh_token")
    private String refreshToken;
    @JSONField(name="scope")
    private String scope;
    @JSONField(name="refresh")
    private boolean refresh;

    private TokenParameter() {
    }

    public static SelfBuilder self() {
        return new SelfBuilder();
    }

    public static CertificateBuilder certificate() {
        return new CertificateBuilder();
    }

    public static CodeBuilder code() {
        return new CodeBuilder();
    }

    public static RefreshBuilder refresh() {
        return new RefreshBuilder();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getGrantId() {
        return this.grantId;
    }

    public String getCode() {
        return this.code;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public String getAuthorizeType() {
        return this.authorizeType;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public static class RefreshBuilder {
        private String clientId;
        private String clientSecret;
        private String refreshToken;

        public RefreshBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public RefreshBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public RefreshBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public TokenParameter build() throws SDKException {
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"clientId can not be null!");
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"clientSecret can not be null!");
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.refreshToken), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"refreshToken can not be null!");
            TokenParameter tokenParameter = new TokenParameter();
            tokenParameter.refreshToken = this.refreshToken;
            tokenParameter.clientId = this.clientId;
            tokenParameter.clientSecret = this.clientSecret;
            tokenParameter.authorizeType = StringUtils.lowerCase((String)OAuthEnum.TokenType.refresh_token.toString());
            return tokenParameter;
        }
    }

    public static class CodeBuilder {
        private String clientId;
        private String clientSecret;
        private String code;

        public CodeBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public CodeBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public CodeBuilder code(String code) {
            this.code = code;
            return this;
        }

        public TokenParameter build() throws SDKException {
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"clientId can not be null!");
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.code), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"code can not be null!");
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"clientSecret can not be null!");
            TokenParameter tokenParameter = new TokenParameter();
            tokenParameter.clientId = this.clientId;
            tokenParameter.clientSecret = this.clientSecret;
            tokenParameter.code = this.code;
            tokenParameter.authorizeType = StringUtils.lowerCase((String)OAuthEnum.TokenType.authorization_code.toString());
            return tokenParameter;
        }
    }

    public static class CertificateBuilder {
        private String clientId;
        private String clientSecret;

        public CertificateBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public CertificateBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public TokenParameter build() throws SDKException {
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"clientId can not be null!");
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"clientSecret can not be null!");
            TokenParameter tokenParameter = new TokenParameter();
            tokenParameter.clientId = this.clientId;
            tokenParameter.clientSecret = this.clientSecret;
            tokenParameter.authorizeType = StringUtils.lowerCase((String)OAuthEnum.TokenType.certificate.toString());
            return tokenParameter;
        }
    }

    public static class SelfBuilder {
        private String clientId;
        private String clientSecret;
        private String grantId;
        private String grantType;
        private boolean refresh;

        public SelfBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public SelfBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public SelfBuilder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public SelfBuilder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public SelfBuilder refresh(Boolean refresh) {
            this.refresh = refresh;
            return this;
        }

        public TokenParameter build() throws SDKException {
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"clientId can not be null!");
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"clientSecret can not be null!");
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.grantId), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"grantId can not be null!");
            TokenParameter tokenParameter = new TokenParameter();
            tokenParameter.grantId = this.grantId;
            tokenParameter.clientId = this.clientId;
            tokenParameter.clientSecret = this.clientSecret;
            tokenParameter.refresh = this.refresh;
            tokenParameter.grantType = this.grantType;
            tokenParameter.authorizeType = StringUtils.lowerCase((String)OAuthEnum.TokenType.silent.toString());
            return tokenParameter;
        }
    }
}

