/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core.oauth.signature.handler;

import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.core.oauth.signature.AbstractSignatureHandler;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;

public class RSA2SignatureHandler
extends AbstractSignatureHandler {
    private static final String signatureAlgorithm = "SHA256withRSA";
    private static KeyFactory rsaKeyFactory;
    private static Signature securitySignature;

    @Override
    public OAuthEnum.Signature grantType() {
        return OAuthEnum.Signature.RSA;
    }

    @Override
    public String sign(String clientPrivateKey, Map<String, Object> requestMap) throws SDKException {
        String requestParams = this.paramSort(requestMap);
        try {
            PrivateKey priKey = rsaKeyFactory.generatePrivate(new PKCS8EncodedKeySpec(this.base64.decode(clientPrivateKey)));
            securitySignature.initSign(priKey);
            securitySignature.update(requestParams.getBytes());
            return this.base64.encodeToString(securitySignature.sign());
        }
        catch (InvalidKeyException | SignatureException | InvalidKeySpecException e) {
            throw new SDKException((Exception)e, OAuthEnum.ErrorMessage.ADD_SIGN_ERROR, "rsa2 add sign exception");
        }
    }

    @Override
    public Boolean check(String youzanPublicKey, Map<String, Object> responseMap, String sign) throws SDKException {
        String responseParams = this.paramSort(responseMap);
        try {
            PublicKey pubKey = rsaKeyFactory.generatePublic(new X509EncodedKeySpec(this.base64.decode(youzanPublicKey)));
            securitySignature.initVerify(pubKey);
            securitySignature.update(responseParams.getBytes());
            return securitySignature.verify(this.base64.decode(sign));
        }
        catch (InvalidKeyException | SignatureException | InvalidKeySpecException e) {
            throw new SDKException((Exception)e, OAuthEnum.ErrorMessage.CHECK_SIGN_ERROR);
        }
    }

    static {
        try {
            securitySignature = Signature.getInstance(signatureAlgorithm);
            rsaKeyFactory = KeyFactory.getInstance(OAuthEnum.Signature.RSA.name());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

