/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core.oauth.signature;

import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.core.oauth.signature.SignatureHandler;
import com.youzan.cloud.open.sdk.core.oauth.signature.handler.RSA2SignatureHandler;
import java.util.concurrent.ConcurrentHashMap;

public class SignatureHandlerFactory {
    private static ConcurrentHashMap<OAuthEnum.Signature, Class> signatureHandlerMap = new ConcurrentHashMap();

    public static SignatureHandler getSignatureHandler(OAuthEnum.Signature signatureType) throws SDKException {
        try {
            return (SignatureHandler)signatureHandlerMap.get(signatureType).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SDKException((Exception)e, OAuthEnum.ErrorMessage.HANDLER_FACTORY_ERROR, e.getMessage());
        }
    }

    static {
        signatureHandlerMap.put(OAuthEnum.Signature.RSA2, RSA2SignatureHandler.class);
    }
}

