/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core.client.executor;

import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.core.client.executor.Executor;
import com.youzan.cloud.open.sdk.core.client.executor.handler.DirectExecutor;
import com.youzan.cloud.open.sdk.core.client.executor.handler.SignExecutor;
import com.youzan.cloud.open.sdk.core.client.executor.handler.TokenExecutor;
import java.util.concurrent.ConcurrentHashMap;

public class ExecuteFactory {
    private static ConcurrentHashMap<OAuthEnum.OAuthType, Class> executeMap = new ConcurrentHashMap();

    public static Executor getExecutor(OAuthEnum.OAuthType oAuthType) throws SDKException {
        try {
            return (Executor)executeMap.get(oAuthType).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SDKException((Exception)e, OAuthEnum.ErrorMessage.HANDLER_FACTORY_ERROR, e.getMessage());
        }
    }

    static {
        executeMap.put(OAuthEnum.OAuthType.TOKEN, TokenExecutor.class);
        executeMap.put(OAuthEnum.OAuthType.SIGN, SignExecutor.class);
        executeMap.put(OAuthEnum.OAuthType.DIRECT, DirectExecutor.class);
    }
}

