/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.dto.ShopCartDTO;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.ShopCart;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.ShopCartMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.bizvane.service.ShopCartService;
import com.wmeimob.fastboot.bizvane.vo.ViewShareGoodsInformRequestVO;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class ShopCartServiceImpl
implements ShopCartService {
    private static final Logger log = LoggerFactory.getLogger(ShopCartServiceImpl.class);
    @Resource
    private ShopCartMapper shopCartMapper;
    @Resource
    private GoodsSkuDetailService goodsSkuDetailService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;

    private boolean isEmptyUser(ShopCart shopCart) {
        return StringUtils.isEmpty((Object)shopCart.getUserNo()) && StringUtils.isEmpty((Object)shopCart.getWechatOpenid()) && shopCart.getUserId() == null;
    }

    private String getUserFlag(ShopCart shopCart) {
        if (StringUtils.isEmpty((Object)shopCart.getWechatOpenid())) {
            return StringUtils.isEmpty((Object)shopCart.getUserNo()) ? shopCart.getUserId() + "" : shopCart.getUserNo();
        }
        return shopCart.getWechatOpenid();
    }

    private void assertUserInfo(ShopCart shopCart) {
        if (this.isEmptyUser(shopCart)) {
            throw new IllegalArgumentException("user info is missing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShopCart add(ShopCart shopCart) {
        this.assertUserInfo(shopCart);
        InputValidator.checkNull((Object)shopCart.getGoodsId(), (String)"\u5546\u54c1ID");
        InputValidator.checkEmpty((Object)shopCart.getSkuNo(), (String)"\u5546\u54c1\u89c4\u683c");
        InputValidator.checkNull((Object)shopCart.getQuantity(), (String)"\u6570\u91cf");
        GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
        goodsSkuDetail.setGoodsId(shopCart.getGoodsId());
        goodsSkuDetail.setSkuNo(shopCart.getSkuNo());
        GoodsSkuDetail skuDetail = (GoodsSkuDetail)this.goodsSkuDetailService.findOneByCondition((Serializable)goodsSkuDetail);
        if (skuDetail.getStock() < 1) {
            throw new CustomException("\u5e93\u5b58\u4e0d\u8db3");
        }
        String key = String.format("user:%s:cartCheck:%s", this.getUserFlag(shopCart), shopCart.getSkuNo());
        try {
            if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"").booleanValue()) {
                throw new CustomException("\u60a8\u7684\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
            }
            ShopCart checkCountDTO = new ShopCart();
            checkCountDTO.setGoodsId(shopCart.getGoodsId());
            checkCountDTO.setSkuNo(shopCart.getSkuNo());
            checkCountDTO.setWechatOpenid(shopCart.getWechatOpenid());
            int selectCount = this.shopCartMapper.selectCount((Object)checkCountDTO);
            if (selectCount == 0) {
                shopCart.setGmtCreate(new Date());
                shopCart.setIsInvalid(Boolean.valueOf(false));
                this.shopCartMapper.insertSelective((Object)shopCart);
                ShopCart shopCart2 = shopCart;
                return shopCart2;
            }
            shopCart.setGmtModified(new Date());
            int result = this.shopCartMapper.incrementCount(shopCart);
            if (result == 0) {
                throw new CustomException("\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25");
            }
            try {
                if (!StringUtils.isEmpty((Object)shopCart.getStaffCode())) {
                    this.notifyAddCartInfoQW(shopCart);
                }
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u8d2d\u7269\u8f66\u901a\u77e5\u4f01\u5fae\u5931\u8d25:msg[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            }
            ShopCart shopCart3 = shopCart;
            return shopCart3;
        }
        finally {
            this.stringRedisTemplate.delete((Object)key);
        }
    }

    private void notifyAddCartInfoQW(ShopCart shopCart) {
        Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)shopCart.getGoodsId());
        CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
        companyBrandRelation.setMerchantId(shopCart.getMerchantId());
        companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne((Object)companyBrandRelation);
        if (goods == null || companyBrandRelation == null) {
            throw new CustomException("\u67e5\u8be2\u5546\u54c1\u6216companyId\u5931\u8d25,\u8bf7\u68c0\u67e5");
        }
        ViewShareGoodsInformRequestVO build = ViewShareGoodsInformRequestVO.builder().goodsName(goods.getGoodsName()).goodsNo(goods.getGoodsNo()).memberCode(shopCart.getMemberCode()).sysCompanyId(companyBrandRelation.getCompanyId()).build();
        this.bizvaneInterface.notifyAddCartInfoQW(build);
    }

    public int delete(Integer id, ShopCart condition) {
        this.assertUserInfo(condition);
        InputValidator.checkNull((Object)condition.getId(), (String)"shop cart id");
        Example example = new Example(ShopCart.class);
        example.createCriteria().andEqualTo("wechatOpenid", (Object)condition.getWechatOpenid()).andEqualTo("id", (Object)condition.getId());
        int result = this.shopCartMapper.deleteByExample((Object)example);
        if (result == 0) {
            throw new CustomException("\u5220\u9664\u5931\u8d25");
        }
        return result;
    }

    public List<ShopCartDTO> queryShopCartGoods(ShopCart condition) {
        this.assertUserInfo(condition);
        List cartList = this.shopCartMapper.selects(condition);
        return cartList;
    }

    public int delete(Integer[] idArr) {
        if (idArr == null || idArr.length == 0) {
            throw new CustomException("\u6ca1\u6709\u5220\u9664\u4efb\u4f55\u9009\u9879");
        }
        Example example = new Example(ShopCart.class);
        example.createCriteria().andIn("id", Arrays.asList(idArr));
        int result = this.shopCartMapper.deleteByExample((Object)example);
        if (result == 0) {
            throw new CustomException("\u6ca1\u6709\u5220\u9664\u4efb\u4f55\u9009\u9879");
        }
        return result;
    }

    public Integer queryCount(ShopCart condition) {
        this.assertUserInfo(condition);
        List cartList = this.shopCartMapper.selects(condition);
        return cartList.size();
    }
}

