/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.config;

import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.core.startup.WmeimobStartUpRunnable;
import com.wmeimob.fastboot.core.startup.WmeimobStartUpRunnableProvider;
import com.wmeimob.fastboot.starter.security.JsonWebTokenHandler;
import com.wmeimob.fastboot.starter.security.JwtAuthenticationFilter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
@EnableAspectJAutoProxy(exposeProxy=true)
public class BizvaneStartUp
implements WmeimobStartUpRunnableProvider {
    private static final Logger log = LoggerFactory.getLogger(BizvaneStartUp.class);
    @Resource
    protected JwtAuthenticationFilter jwtAuthenticationTokenFilter;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public void run(WmeimobStartUpRunnable wmeimobStartUpRunnable) {
        log.info("*******************  BizvaneStartUp run ... *******************");
        wmeimobStartUpRunnable.run(WmeimobStartUpRunnable.Mode.OVERRIDE, () -> {
            log.info("*******************  WmeimobStartUpRunnable run ... *******************");
            JsonWebTokenHandler jsonWebTokenHandler = this.jwtAuthenticationTokenFilter.getJsonWebTokenHandler();
            jsonWebTokenHandler.setJsonWebTokenDecoder(claims -> {
                String openid = (String)claims.get((Object)"openid");
                String userNo = (String)claims.get((Object)"userNo");
                String appid = (String)claims.get((Object)"appid");
                String unionId = (String)claims.get((Object)"unionid");
                Integer merchantId = (Integer)claims.get((Object)"merchantId");
                Integer brandId = (Integer)claims.get((Object)"brandId");
                Integer userId = (Integer)claims.get((Object)"userId");
                User user = new User();
                user.setOpenid(openid);
                user.setUserNo(userNo);
                user.setAppid(appid);
                user.setUnionid(unionId);
                user.setMerchantId(merchantId);
                user.setBrandId(brandId);
                user.setUserId(userId);
                List hashMaps = (List)claims.get((Object)"roles");
                List authorities = hashMaps.stream().map(mp -> (GrantedAuthority & Serializable)() -> (String)mp.get("authority")).collect(Collectors.toList());
                user.setAuthorities(authorities);
                return user;
            });
            jsonWebTokenHandler.setJsonWebTokenEncoder(userDetails -> {
                User user = (User)userDetails;
                HashMap<String, Object> claims = new HashMap<String, Object>();
                claims.put("openid", user.getOpenid());
                claims.put("userNo", user.getUserNo());
                claims.put("appid", user.getAppid());
                claims.put("roles", user.getAuthorities());
                claims.put("unionid", user.getUnionid());
                claims.put("merchantId", user.getMerchantId());
                claims.put("brandId", user.getBrandId());
                claims.put("userId", user.getUserId());
                return claims;
            });
            jsonWebTokenHandler.setJsonWebTokenReplayAttacksDefiniens((ud, token) -> {
                User user = (User)ud;
                this.stringRedisTemplate.opsForValue().set((Object)("opens:authorizer_appids:" + user.getAppid() + ":openids:" + user.getOpenid() + ":token"), (Object)token);
            });
            jsonWebTokenHandler.setJsonWebTokenReplayAttacksDetector((token, userDetails) -> {
                User user = (User)userDetails;
                String cacheToken = (String)this.stringRedisTemplate.opsForValue().get((Object)("opens:authorizer_appids:" + user.getAppid() + ":openids:" + user.getOpenid() + ":token"));
                if (!token.equals(cacheToken)) {
                    throw new BadCredentialsException("\u65e0\u6548\u7684token");
                }
            });
            log.info("*******************  WmeimobStartUpRunnable run end *******************");
        });
        log.info("*******************  BizvaneStartUp run end *******************");
    }
}

