/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.jsonrpc2.client;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.thetransactioncompany.jsonrpc2.client.ConnectionConfigurator;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2SessionException;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2SessionOptions;
import com.thetransactioncompany.jsonrpc2.client.RawResponse;
import com.thetransactioncompany.jsonrpc2.client.RawResponseInspector;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JSONRPC2Session {
    private URL url;
    private JSONRPC2SessionOptions options;
    private ConnectionConfigurator connectionConfigurator;
    private RawResponseInspector responseInspector;
    private CookieManager cookieManager;
    private static final SSLSocketFactory trustAllSocketFactory = JSONRPC2Session.createTrustAllSocketFactory();

    public JSONRPC2Session(URL url) {
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("The URL protocol must be HTTP or HTTPS");
        }
        this.url = url;
        this.options = new JSONRPC2SessionOptions();
        this.connectionConfigurator = null;
    }

    public static SSLSocketFactory createTrustAllSocketFactory() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (Exception e) {
            return null;
        }
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("The server URL must not be null");
        }
        this.url = url;
    }

    public JSONRPC2SessionOptions getOptions() {
        return this.options;
    }

    public void setOptions(JSONRPC2SessionOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("The client session options must not be null");
        }
        this.options = options;
    }

    public ConnectionConfigurator getConnectionConfigurator() {
        return this.connectionConfigurator;
    }

    public void setConnectionConfigurator(ConnectionConfigurator connectionConfigurator) {
        this.connectionConfigurator = connectionConfigurator;
    }

    public RawResponseInspector getRawResponseInspector() {
        return this.responseInspector;
    }

    public void setRawResponseInspector(RawResponseInspector responseInspector) {
        this.responseInspector = responseInspector;
    }

    public List<HttpCookie> getCookies() {
        if (this.cookieManager == null) {
            return Collections.emptyList();
        }
        return this.cookieManager.getCookieStore().getCookies();
    }

    private void applyHeaders(URLConnection con) {
        con.setRequestProperty("Accept-Charset", "UTF-8");
        if (this.options.getRequestContentType() != null) {
            con.setRequestProperty("Content-Type", this.options.getRequestContentType());
        }
        if (this.options.getOrigin() != null) {
            con.setRequestProperty("Origin", this.options.getOrigin());
        }
        if (this.options.enableCompression()) {
            con.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        if (this.options.acceptCookies()) {
            StringBuilder buf = new StringBuilder();
            for (HttpCookie cookie : this.getCookies()) {
                if (buf.length() > 0) {
                    buf.append("; ");
                }
                buf.append(cookie.toString());
            }
            con.setRequestProperty("Cookie", buf.toString());
        }
    }

    private URLConnection createURLConnection() throws JSONRPC2SessionException {
        URLConnection con;
        try {
            con = this.options.getProxy() != null ? this.url.openConnection(this.options.getProxy()) : this.url.openConnection();
        }
        catch (IOException e) {
            throw new JSONRPC2SessionException("Network exception: " + e.getMessage(), 1, e);
        }
        con.setConnectTimeout(this.options.getConnectTimeout());
        con.setReadTimeout(this.options.getReadTimeout());
        this.applyHeaders(con);
        con.setDoOutput(true);
        if (con instanceof HttpsURLConnection && this.options.trustsAllCerts()) {
            if (trustAllSocketFactory == null) {
                throw new JSONRPC2SessionException("Couldn't obtain trust-all SSL socket factory");
            }
            ((HttpsURLConnection)con).setSSLSocketFactory(trustAllSocketFactory);
        }
        if (this.connectionConfigurator != null) {
            this.connectionConfigurator.configure((HttpURLConnection)con);
        }
        return con;
    }

    private static void postString(URLConnection con, String data) throws JSONRPC2SessionException {
        try {
            OutputStreamWriter wr = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
            wr.write(data);
            wr.flush();
            wr.close();
        }
        catch (IOException e) {
            throw new JSONRPC2SessionException("Network exception: " + e.getMessage(), 1, e);
        }
    }

    private RawResponse readRawResponse(URLConnection con) throws JSONRPC2SessionException {
        RawResponse rawResponse;
        try {
            rawResponse = RawResponse.parse((HttpURLConnection)con);
        }
        catch (IOException e) {
            throw new JSONRPC2SessionException("Network exception: " + e.getMessage(), 1, e);
        }
        if (this.responseInspector != null) {
            this.responseInspector.inspect(rawResponse);
        }
        if (this.options.acceptCookies()) {
            if (this.cookieManager == null) {
                this.cookieManager = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
            }
            try {
                this.cookieManager.put(con.getURL().toURI(), rawResponse.getHeaderFields());
            }
            catch (URISyntaxException e) {
                throw new JSONRPC2SessionException("Network exception: " + e.getMessage(), 1, e);
            }
            catch (IOException e) {
                throw new JSONRPC2SessionException("I/O exception: " + e.getMessage(), 1, e);
            }
        }
        return rawResponse;
    }

    public JSONRPC2Response send(JSONRPC2Request request) throws JSONRPC2SessionException {
        JSONRPC2Response response;
        URLConnection con = this.createURLConnection();
        JSONRPC2Session.postString(con, request.toString());
        RawResponse rawResponse = this.readRawResponse(con);
        String contentType = rawResponse.getContentType();
        if (!this.options.isAllowedResponseContentType(contentType)) {
            String msg = contentType == null ? "Missing Content-Type header in the HTTP response" : "Unexpected \"" + contentType + "\" content type of the HTTP response";
            throw new JSONRPC2SessionException(msg, 2);
        }
        try {
            response = JSONRPC2Response.parse((String)rawResponse.getContent(), (boolean)this.options.preservesParseOrder(), (boolean)this.options.ignoresVersion(), (boolean)this.options.parsesNonStdAttributes());
        }
        catch (JSONRPC2ParseException e) {
            throw new JSONRPC2SessionException("Invalid JSON-RPC 2.0 response", 3, e);
        }
        Object reqID = request.getID();
        Object resID = response.getID();
        if (!(reqID != null && resID != null && reqID.toString().equals(resID.toString()) || reqID == null && resID == null || !response.indicatesSuccess() && (response.getError().getCode() == -32700 || response.getError().getCode() == -32600 || response.getError().getCode() == -32603))) {
            throw new JSONRPC2SessionException("Invalid JSON-RPC 2.0 response: ID mismatch: Returned " + resID + ", expected " + reqID, 3);
        }
        return response;
    }

    public void send(JSONRPC2Notification notification) throws JSONRPC2SessionException {
        URLConnection con = this.createURLConnection();
        JSONRPC2Session.postString(con, notification.toString());
    }
}

