/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.jsonrpc2;

import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Parser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public abstract class JSONRPC2Message
implements JSONAware {
    private Map<String, Object> nonStdAttributes = null;

    public static JSONRPC2Message parse(String jsonString) throws JSONRPC2ParseException {
        return JSONRPC2Message.parse(jsonString, false, false);
    }

    public static JSONRPC2Message parse(String jsonString, boolean preserveOrder, boolean ignoreVersion) throws JSONRPC2ParseException {
        JSONRPC2Parser parser = new JSONRPC2Parser(preserveOrder, ignoreVersion);
        return parser.parseJSONRPC2Message(jsonString);
    }

    public void appendNonStdAttribute(String name, Object value) {
        if (name == null || name.equals("method") || name.equals("id") || name.equals("params") || name.equals("result") || name.equals("error") || name.equals("jsonrpc")) {
            throw new IllegalArgumentException("Non-standard attribute name violation");
        }
        if (!(value == null || value instanceof Boolean || value instanceof Number || value instanceof String || value instanceof List || value instanceof Map)) {
            throw new IllegalArgumentException("Illegal non-standard attribute value, must map to a valid JSON type");
        }
        if (this.nonStdAttributes == null) {
            this.nonStdAttributes = new HashMap<String, Object>();
        }
        this.nonStdAttributes.put(name, value);
    }

    public Object getNonStdAttribute(String name) {
        if (this.nonStdAttributes == null) {
            return null;
        }
        return this.nonStdAttributes.get(name);
    }

    public Map<String, Object> getNonStdAttributes() {
        return this.nonStdAttributes;
    }

    public abstract JSONObject toJSONObject();

    public String toJSONString() {
        return this.toString();
    }

    public String toString() {
        return this.toJSONObject().toString();
    }
}

