/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ProdSchedulerTask extends AbstractModel {

    /**
    * 生产调度任务工作流ID
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("WorkflowId")
    @Expose
    private String WorkflowId;

    /**
    * 生产调度任务Id
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("TaskId")
    @Expose
    private String TaskId;

    /**
    * 生产调度任务名称
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("TaskName")
    @Expose
    private String TaskName;

    /**
    * 生产调度任务任务类型
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("CycleType")
    @Expose
    private Long CycleType;

    /**
     * Get 生产调度任务工作流ID
注意：此字段可能返回 null，表示取不到有效值。 
     * @return WorkflowId 生产调度任务工作流ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getWorkflowId() {
        return this.WorkflowId;
    }

    /**
     * Set 生产调度任务工作流ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param WorkflowId 生产调度任务工作流ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setWorkflowId(String WorkflowId) {
        this.WorkflowId = WorkflowId;
    }

    /**
     * Get 生产调度任务Id
注意：此字段可能返回 null，表示取不到有效值。 
     * @return TaskId 生产调度任务Id
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getTaskId() {
        return this.TaskId;
    }

    /**
     * Set 生产调度任务Id
注意：此字段可能返回 null，表示取不到有效值。
     * @param TaskId 生产调度任务Id
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setTaskId(String TaskId) {
        this.TaskId = TaskId;
    }

    /**
     * Get 生产调度任务名称
注意：此字段可能返回 null，表示取不到有效值。 
     * @return TaskName 生产调度任务名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getTaskName() {
        return this.TaskName;
    }

    /**
     * Set 生产调度任务名称
注意：此字段可能返回 null，表示取不到有效值。
     * @param TaskName 生产调度任务名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setTaskName(String TaskName) {
        this.TaskName = TaskName;
    }

    /**
     * Get 生产调度任务任务类型
注意：此字段可能返回 null，表示取不到有效值。 
     * @return CycleType 生产调度任务任务类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getCycleType() {
        return this.CycleType;
    }

    /**
     * Set 生产调度任务任务类型
注意：此字段可能返回 null，表示取不到有效值。
     * @param CycleType 生产调度任务任务类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setCycleType(Long CycleType) {
        this.CycleType = CycleType;
    }

    public ProdSchedulerTask() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ProdSchedulerTask(ProdSchedulerTask source) {
        if (source.WorkflowId != null) {
            this.WorkflowId = new String(source.WorkflowId);
        }
        if (source.TaskId != null) {
            this.TaskId = new String(source.TaskId);
        }
        if (source.TaskName != null) {
            this.TaskName = new String(source.TaskName);
        }
        if (source.CycleType != null) {
            this.CycleType = new Long(source.CycleType);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "WorkflowId", this.WorkflowId);
        this.setParamSimple(map, prefix + "TaskId", this.TaskId);
        this.setParamSimple(map, prefix + "TaskName", this.TaskName);
        this.setParamSimple(map, prefix + "CycleType", this.CycleType);

    }
}

