/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ses.v20201002.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateReceiverDetailWithDataResponse extends AbstractModel {

    /**
    * 收件人总数
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * 实际上传数量
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ValidCount")
    @Expose
    private Long ValidCount;

    /**
    * 数据过长数量
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("TooLongCount")
    @Expose
    private Long TooLongCount;

    /**
    * 邮件地址为空数量
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("EmptyEmailCount")
    @Expose
    private Long EmptyEmailCount;

    /**
    * 重复数量
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("RepeatCount")
    @Expose
    private Long RepeatCount;

    /**
    * 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 收件人总数
注意：此字段可能返回 null，表示取不到有效值。 
     * @return TotalCount 收件人总数
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set 收件人总数
注意：此字段可能返回 null，表示取不到有效值。
     * @param TotalCount 收件人总数
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get 实际上传数量
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ValidCount 实际上传数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getValidCount() {
        return this.ValidCount;
    }

    /**
     * Set 实际上传数量
注意：此字段可能返回 null，表示取不到有效值。
     * @param ValidCount 实际上传数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setValidCount(Long ValidCount) {
        this.ValidCount = ValidCount;
    }

    /**
     * Get 数据过长数量
注意：此字段可能返回 null，表示取不到有效值。 
     * @return TooLongCount 数据过长数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getTooLongCount() {
        return this.TooLongCount;
    }

    /**
     * Set 数据过长数量
注意：此字段可能返回 null，表示取不到有效值。
     * @param TooLongCount 数据过长数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setTooLongCount(Long TooLongCount) {
        this.TooLongCount = TooLongCount;
    }

    /**
     * Get 邮件地址为空数量
注意：此字段可能返回 null，表示取不到有效值。 
     * @return EmptyEmailCount 邮件地址为空数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getEmptyEmailCount() {
        return this.EmptyEmailCount;
    }

    /**
     * Set 邮件地址为空数量
注意：此字段可能返回 null，表示取不到有效值。
     * @param EmptyEmailCount 邮件地址为空数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setEmptyEmailCount(Long EmptyEmailCount) {
        this.EmptyEmailCount = EmptyEmailCount;
    }

    /**
     * Get 重复数量
注意：此字段可能返回 null，表示取不到有效值。 
     * @return RepeatCount 重复数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getRepeatCount() {
        return this.RepeatCount;
    }

    /**
     * Set 重复数量
注意：此字段可能返回 null，表示取不到有效值。
     * @param RepeatCount 重复数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setRepeatCount(Long RepeatCount) {
        this.RepeatCount = RepeatCount;
    }

    /**
     * Get 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public CreateReceiverDetailWithDataResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateReceiverDetailWithDataResponse(CreateReceiverDetailWithDataResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.ValidCount != null) {
            this.ValidCount = new Long(source.ValidCount);
        }
        if (source.TooLongCount != null) {
            this.TooLongCount = new Long(source.TooLongCount);
        }
        if (source.EmptyEmailCount != null) {
            this.EmptyEmailCount = new Long(source.EmptyEmailCount);
        }
        if (source.RepeatCount != null) {
            this.RepeatCount = new Long(source.RepeatCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "ValidCount", this.ValidCount);
        this.setParamSimple(map, prefix + "TooLongCount", this.TooLongCount);
        this.setParamSimple(map, prefix + "EmptyEmailCount", this.EmptyEmailCount);
        this.setParamSimple(map, prefix + "RepeatCount", this.RepeatCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

