/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.monitor.v20180724.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class PrometheusAgentOverview extends AbstractModel {

    /**
    * 集群类型
    */
    @SerializedName("ClusterType")
    @Expose
    private String ClusterType;

    /**
    * 集群id
    */
    @SerializedName("ClusterId")
    @Expose
    private String ClusterId;

    /**
    * agent状态
normal = 正常
abnormal = 异常
    */
    @SerializedName("Status")
    @Expose
    private String Status;

    /**
    * 集群名称
    */
    @SerializedName("ClusterName")
    @Expose
    private String ClusterName;

    /**
    * 额外labels
本集群的所有指标都会带上这几个label
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ExternalLabels")
    @Expose
    private Label [] ExternalLabels;

    /**
    * 集群所在地域
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Region")
    @Expose
    private String Region;

    /**
    * 集群所在VPC ID
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("VpcId")
    @Expose
    private String VpcId;

    /**
    * 记录关联等操作的失败信息
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("FailedReason")
    @Expose
    private String FailedReason;

    /**
    * agent名称
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * 是否已开启公网访问，true 开启，false 未开启
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("EnableExternal")
    @Expose
    private Boolean EnableExternal;

    /**
    * 采集agent期望pod数
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("DesiredAgentNum")
    @Expose
    private Long DesiredAgentNum;

    /**
    * 采集agent已正常启动pod数
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ReadyAgentNum")
    @Expose
    private Long ReadyAgentNum;

    /**
     * Get 集群类型 
     * @return ClusterType 集群类型
     */
    public String getClusterType() {
        return this.ClusterType;
    }

    /**
     * Set 集群类型
     * @param ClusterType 集群类型
     */
    public void setClusterType(String ClusterType) {
        this.ClusterType = ClusterType;
    }

    /**
     * Get 集群id 
     * @return ClusterId 集群id
     */
    public String getClusterId() {
        return this.ClusterId;
    }

    /**
     * Set 集群id
     * @param ClusterId 集群id
     */
    public void setClusterId(String ClusterId) {
        this.ClusterId = ClusterId;
    }

    /**
     * Get agent状态
normal = 正常
abnormal = 异常 
     * @return Status agent状态
normal = 正常
abnormal = 异常
     */
    public String getStatus() {
        return this.Status;
    }

    /**
     * Set agent状态
normal = 正常
abnormal = 异常
     * @param Status agent状态
normal = 正常
abnormal = 异常
     */
    public void setStatus(String Status) {
        this.Status = Status;
    }

    /**
     * Get 集群名称 
     * @return ClusterName 集群名称
     */
    public String getClusterName() {
        return this.ClusterName;
    }

    /**
     * Set 集群名称
     * @param ClusterName 集群名称
     */
    public void setClusterName(String ClusterName) {
        this.ClusterName = ClusterName;
    }

    /**
     * Get 额外labels
本集群的所有指标都会带上这几个label
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ExternalLabels 额外labels
本集群的所有指标都会带上这几个label
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Label [] getExternalLabels() {
        return this.ExternalLabels;
    }

    /**
     * Set 额外labels
本集群的所有指标都会带上这几个label
注意：此字段可能返回 null，表示取不到有效值。
     * @param ExternalLabels 额外labels
本集群的所有指标都会带上这几个label
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setExternalLabels(Label [] ExternalLabels) {
        this.ExternalLabels = ExternalLabels;
    }

    /**
     * Get 集群所在地域
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Region 集群所在地域
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getRegion() {
        return this.Region;
    }

    /**
     * Set 集群所在地域
注意：此字段可能返回 null，表示取不到有效值。
     * @param Region 集群所在地域
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setRegion(String Region) {
        this.Region = Region;
    }

    /**
     * Get 集群所在VPC ID
注意：此字段可能返回 null，表示取不到有效值。 
     * @return VpcId 集群所在VPC ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getVpcId() {
        return this.VpcId;
    }

    /**
     * Set 集群所在VPC ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param VpcId 集群所在VPC ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setVpcId(String VpcId) {
        this.VpcId = VpcId;
    }

    /**
     * Get 记录关联等操作的失败信息
注意：此字段可能返回 null，表示取不到有效值。 
     * @return FailedReason 记录关联等操作的失败信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getFailedReason() {
        return this.FailedReason;
    }

    /**
     * Set 记录关联等操作的失败信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param FailedReason 记录关联等操作的失败信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setFailedReason(String FailedReason) {
        this.FailedReason = FailedReason;
    }

    /**
     * Get agent名称
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Name agent名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set agent名称
注意：此字段可能返回 null，表示取不到有效值。
     * @param Name agent名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get 是否已开启公网访问，true 开启，false 未开启
注意：此字段可能返回 null，表示取不到有效值。 
     * @return EnableExternal 是否已开启公网访问，true 开启，false 未开启
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Boolean getEnableExternal() {
        return this.EnableExternal;
    }

    /**
     * Set 是否已开启公网访问，true 开启，false 未开启
注意：此字段可能返回 null，表示取不到有效值。
     * @param EnableExternal 是否已开启公网访问，true 开启，false 未开启
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setEnableExternal(Boolean EnableExternal) {
        this.EnableExternal = EnableExternal;
    }

    /**
     * Get 采集agent期望pod数
注意：此字段可能返回 null，表示取不到有效值。 
     * @return DesiredAgentNum 采集agent期望pod数
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getDesiredAgentNum() {
        return this.DesiredAgentNum;
    }

    /**
     * Set 采集agent期望pod数
注意：此字段可能返回 null，表示取不到有效值。
     * @param DesiredAgentNum 采集agent期望pod数
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setDesiredAgentNum(Long DesiredAgentNum) {
        this.DesiredAgentNum = DesiredAgentNum;
    }

    /**
     * Get 采集agent已正常启动pod数
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ReadyAgentNum 采集agent已正常启动pod数
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getReadyAgentNum() {
        return this.ReadyAgentNum;
    }

    /**
     * Set 采集agent已正常启动pod数
注意：此字段可能返回 null，表示取不到有效值。
     * @param ReadyAgentNum 采集agent已正常启动pod数
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setReadyAgentNum(Long ReadyAgentNum) {
        this.ReadyAgentNum = ReadyAgentNum;
    }

    public PrometheusAgentOverview() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public PrometheusAgentOverview(PrometheusAgentOverview source) {
        if (source.ClusterType != null) {
            this.ClusterType = new String(source.ClusterType);
        }
        if (source.ClusterId != null) {
            this.ClusterId = new String(source.ClusterId);
        }
        if (source.Status != null) {
            this.Status = new String(source.Status);
        }
        if (source.ClusterName != null) {
            this.ClusterName = new String(source.ClusterName);
        }
        if (source.ExternalLabels != null) {
            this.ExternalLabels = new Label[source.ExternalLabels.length];
            for (int i = 0; i < source.ExternalLabels.length; i++) {
                this.ExternalLabels[i] = new Label(source.ExternalLabels[i]);
            }
        }
        if (source.Region != null) {
            this.Region = new String(source.Region);
        }
        if (source.VpcId != null) {
            this.VpcId = new String(source.VpcId);
        }
        if (source.FailedReason != null) {
            this.FailedReason = new String(source.FailedReason);
        }
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.EnableExternal != null) {
            this.EnableExternal = new Boolean(source.EnableExternal);
        }
        if (source.DesiredAgentNum != null) {
            this.DesiredAgentNum = new Long(source.DesiredAgentNum);
        }
        if (source.ReadyAgentNum != null) {
            this.ReadyAgentNum = new Long(source.ReadyAgentNum);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ClusterType", this.ClusterType);
        this.setParamSimple(map, prefix + "ClusterId", this.ClusterId);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "ClusterName", this.ClusterName);
        this.setParamArrayObj(map, prefix + "ExternalLabels.", this.ExternalLabels);
        this.setParamSimple(map, prefix + "Region", this.Region);
        this.setParamSimple(map, prefix + "VpcId", this.VpcId);
        this.setParamSimple(map, prefix + "FailedReason", this.FailedReason);
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "EnableExternal", this.EnableExternal);
        this.setParamSimple(map, prefix + "DesiredAgentNum", this.DesiredAgentNum);
        this.setParamSimple(map, prefix + "ReadyAgentNum", this.ReadyAgentNum);

    }
}

