/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.mna.v20210119.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetDevicePayModeRequest extends AbstractModel {

    /**
    * 设备ID列表
    */
    @SerializedName("DeviceIdList")
    @Expose
    private String [] DeviceIdList;

    /**
     * Get 设备ID列表 
     * @return DeviceIdList 设备ID列表
     */
    public String [] getDeviceIdList() {
        return this.DeviceIdList;
    }

    /**
     * Set 设备ID列表
     * @param DeviceIdList 设备ID列表
     */
    public void setDeviceIdList(String [] DeviceIdList) {
        this.DeviceIdList = DeviceIdList;
    }

    public GetDevicePayModeRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetDevicePayModeRequest(GetDevicePayModeRequest source) {
        if (source.DeviceIdList != null) {
            this.DeviceIdList = new String[source.DeviceIdList.length];
            for (int i = 0; i < source.DeviceIdList.length; i++) {
                this.DeviceIdList[i] = new String(source.DeviceIdList[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "DeviceIdList.", this.DeviceIdList);

    }
}

