/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ioa.v20220601.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RuleItem extends AbstractModel {

    /**
    * 字段名称
    */
    @SerializedName("Key")
    @Expose
    private String Key;

    /**
    * 操作关系（等于、不等于、包含、不包含）
    */
    @SerializedName("Operate")
    @Expose
    private String Operate;

    /**
    * 内容
    */
    @SerializedName("Value")
    @Expose
    private String Value;

    /**
    * 内容，v2多值版本使用
    */
    @SerializedName("Values")
    @Expose
    private String [] Values;

    /**
     * Get 字段名称 
     * @return Key 字段名称
     */
    public String getKey() {
        return this.Key;
    }

    /**
     * Set 字段名称
     * @param Key 字段名称
     */
    public void setKey(String Key) {
        this.Key = Key;
    }

    /**
     * Get 操作关系（等于、不等于、包含、不包含） 
     * @return Operate 操作关系（等于、不等于、包含、不包含）
     */
    public String getOperate() {
        return this.Operate;
    }

    /**
     * Set 操作关系（等于、不等于、包含、不包含）
     * @param Operate 操作关系（等于、不等于、包含、不包含）
     */
    public void setOperate(String Operate) {
        this.Operate = Operate;
    }

    /**
     * Get 内容 
     * @return Value 内容
     */
    public String getValue() {
        return this.Value;
    }

    /**
     * Set 内容
     * @param Value 内容
     */
    public void setValue(String Value) {
        this.Value = Value;
    }

    /**
     * Get 内容，v2多值版本使用 
     * @return Values 内容，v2多值版本使用
     */
    public String [] getValues() {
        return this.Values;
    }

    /**
     * Set 内容，v2多值版本使用
     * @param Values 内容，v2多值版本使用
     */
    public void setValues(String [] Values) {
        this.Values = Values;
    }

    public RuleItem() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RuleItem(RuleItem source) {
        if (source.Key != null) {
            this.Key = new String(source.Key);
        }
        if (source.Operate != null) {
            this.Operate = new String(source.Operate);
        }
        if (source.Value != null) {
            this.Value = new String(source.Value);
        }
        if (source.Values != null) {
            this.Values = new String[source.Values.length];
            for (int i = 0; i < source.Values.length; i++) {
                this.Values[i] = new String(source.Values[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Key", this.Key);
        this.setParamSimple(map, prefix + "Operate", this.Operate);
        this.setParamSimple(map, prefix + "Value", this.Value);
        this.setParamArraySimple(map, prefix + "Values.", this.Values);

    }
}

