/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.hunyuan.v20230901.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class FilesUploadsRequest extends AbstractModel {

    /**
    * 文件名。
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * 文件链接。目前仅支持 pdf 格式，单文件大小限制为100M。
    */
    @SerializedName("URL")
    @Expose
    private String URL;

    /**
     * Get 文件名。 
     * @return Name 文件名。
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set 文件名。
     * @param Name 文件名。
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get 文件链接。目前仅支持 pdf 格式，单文件大小限制为100M。 
     * @return URL 文件链接。目前仅支持 pdf 格式，单文件大小限制为100M。
     */
    public String getURL() {
        return this.URL;
    }

    /**
     * Set 文件链接。目前仅支持 pdf 格式，单文件大小限制为100M。
     * @param URL 文件链接。目前仅支持 pdf 格式，单文件大小限制为100M。
     */
    public void setURL(String URL) {
        this.URL = URL;
    }

    public FilesUploadsRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public FilesUploadsRequest(FilesUploadsRequest source) {
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.URL != null) {
            this.URL = new String(source.URL);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "URL", this.URL);

    }
}

