/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class MalwareWhiteListInfo extends AbstractModel {

    /**
    * 唯一ID。
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * cvm quuid 按,分割。
    */
    @SerializedName("QuuidList")
    @Expose
    private String QuuidList;

    /**
    * md5列表 按,分割
    */
    @SerializedName("Md5List")
    @Expose
    private String Md5List;

    /**
    * 是否全部主机； 0否，1是
    */
    @SerializedName("IsGlobal")
    @Expose
    private Long IsGlobal;

    /**
    * 白名单模式；0 MD5 ，1自定义
    */
    @SerializedName("Mode")
    @Expose
    private Long Mode;

    /**
    * 匹配模式；0精确匹配，1模糊匹配
    */
    @SerializedName("MatchType")
    @Expose
    private Long MatchType;

    /**
    * 文件名；按,分割
    */
    @SerializedName("FileName")
    @Expose
    private String FileName;

    /**
    * 文件目录；按,分割
    */
    @SerializedName("FileDirectory")
    @Expose
    private String FileDirectory;

    /**
    * 文件后缀；按,分割
    */
    @SerializedName("FileExtension")
    @Expose
    private String FileExtension;

    /**
    * 规则创建时间
    */
    @SerializedName("CreateTime")
    @Expose
    private String CreateTime;

    /**
    * 受影响记录
    */
    @SerializedName("EventsCount")
    @Expose
    private Long EventsCount;

    /**
    * 规则修改时间
    */
    @SerializedName("ModifyTime")
    @Expose
    private String ModifyTime;

    /**
     * Get 唯一ID。 
     * @return Id 唯一ID。
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set 唯一ID。
     * @param Id 唯一ID。
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get cvm quuid 按,分割。 
     * @return QuuidList cvm quuid 按,分割。
     */
    public String getQuuidList() {
        return this.QuuidList;
    }

    /**
     * Set cvm quuid 按,分割。
     * @param QuuidList cvm quuid 按,分割。
     */
    public void setQuuidList(String QuuidList) {
        this.QuuidList = QuuidList;
    }

    /**
     * Get md5列表 按,分割 
     * @return Md5List md5列表 按,分割
     */
    public String getMd5List() {
        return this.Md5List;
    }

    /**
     * Set md5列表 按,分割
     * @param Md5List md5列表 按,分割
     */
    public void setMd5List(String Md5List) {
        this.Md5List = Md5List;
    }

    /**
     * Get 是否全部主机； 0否，1是 
     * @return IsGlobal 是否全部主机； 0否，1是
     */
    public Long getIsGlobal() {
        return this.IsGlobal;
    }

    /**
     * Set 是否全部主机； 0否，1是
     * @param IsGlobal 是否全部主机； 0否，1是
     */
    public void setIsGlobal(Long IsGlobal) {
        this.IsGlobal = IsGlobal;
    }

    /**
     * Get 白名单模式；0 MD5 ，1自定义 
     * @return Mode 白名单模式；0 MD5 ，1自定义
     */
    public Long getMode() {
        return this.Mode;
    }

    /**
     * Set 白名单模式；0 MD5 ，1自定义
     * @param Mode 白名单模式；0 MD5 ，1自定义
     */
    public void setMode(Long Mode) {
        this.Mode = Mode;
    }

    /**
     * Get 匹配模式；0精确匹配，1模糊匹配 
     * @return MatchType 匹配模式；0精确匹配，1模糊匹配
     */
    public Long getMatchType() {
        return this.MatchType;
    }

    /**
     * Set 匹配模式；0精确匹配，1模糊匹配
     * @param MatchType 匹配模式；0精确匹配，1模糊匹配
     */
    public void setMatchType(Long MatchType) {
        this.MatchType = MatchType;
    }

    /**
     * Get 文件名；按,分割 
     * @return FileName 文件名；按,分割
     */
    public String getFileName() {
        return this.FileName;
    }

    /**
     * Set 文件名；按,分割
     * @param FileName 文件名；按,分割
     */
    public void setFileName(String FileName) {
        this.FileName = FileName;
    }

    /**
     * Get 文件目录；按,分割 
     * @return FileDirectory 文件目录；按,分割
     */
    public String getFileDirectory() {
        return this.FileDirectory;
    }

    /**
     * Set 文件目录；按,分割
     * @param FileDirectory 文件目录；按,分割
     */
    public void setFileDirectory(String FileDirectory) {
        this.FileDirectory = FileDirectory;
    }

    /**
     * Get 文件后缀；按,分割 
     * @return FileExtension 文件后缀；按,分割
     */
    public String getFileExtension() {
        return this.FileExtension;
    }

    /**
     * Set 文件后缀；按,分割
     * @param FileExtension 文件后缀；按,分割
     */
    public void setFileExtension(String FileExtension) {
        this.FileExtension = FileExtension;
    }

    /**
     * Get 规则创建时间 
     * @return CreateTime 规则创建时间
     */
    public String getCreateTime() {
        return this.CreateTime;
    }

    /**
     * Set 规则创建时间
     * @param CreateTime 规则创建时间
     */
    public void setCreateTime(String CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * Get 受影响记录 
     * @return EventsCount 受影响记录
     */
    public Long getEventsCount() {
        return this.EventsCount;
    }

    /**
     * Set 受影响记录
     * @param EventsCount 受影响记录
     */
    public void setEventsCount(Long EventsCount) {
        this.EventsCount = EventsCount;
    }

    /**
     * Get 规则修改时间 
     * @return ModifyTime 规则修改时间
     */
    public String getModifyTime() {
        return this.ModifyTime;
    }

    /**
     * Set 规则修改时间
     * @param ModifyTime 规则修改时间
     */
    public void setModifyTime(String ModifyTime) {
        this.ModifyTime = ModifyTime;
    }

    public MalwareWhiteListInfo() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public MalwareWhiteListInfo(MalwareWhiteListInfo source) {
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.QuuidList != null) {
            this.QuuidList = new String(source.QuuidList);
        }
        if (source.Md5List != null) {
            this.Md5List = new String(source.Md5List);
        }
        if (source.IsGlobal != null) {
            this.IsGlobal = new Long(source.IsGlobal);
        }
        if (source.Mode != null) {
            this.Mode = new Long(source.Mode);
        }
        if (source.MatchType != null) {
            this.MatchType = new Long(source.MatchType);
        }
        if (source.FileName != null) {
            this.FileName = new String(source.FileName);
        }
        if (source.FileDirectory != null) {
            this.FileDirectory = new String(source.FileDirectory);
        }
        if (source.FileExtension != null) {
            this.FileExtension = new String(source.FileExtension);
        }
        if (source.CreateTime != null) {
            this.CreateTime = new String(source.CreateTime);
        }
        if (source.EventsCount != null) {
            this.EventsCount = new Long(source.EventsCount);
        }
        if (source.ModifyTime != null) {
            this.ModifyTime = new String(source.ModifyTime);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "QuuidList", this.QuuidList);
        this.setParamSimple(map, prefix + "Md5List", this.Md5List);
        this.setParamSimple(map, prefix + "IsGlobal", this.IsGlobal);
        this.setParamSimple(map, prefix + "Mode", this.Mode);
        this.setParamSimple(map, prefix + "MatchType", this.MatchType);
        this.setParamSimple(map, prefix + "FileName", this.FileName);
        this.setParamSimple(map, prefix + "FileDirectory", this.FileDirectory);
        this.setParamSimple(map, prefix + "FileExtension", this.FileExtension);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "EventsCount", this.EventsCount);
        this.setParamSimple(map, prefix + "ModifyTime", this.ModifyTime);

    }
}

