/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ccc.v20200210.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class IMSatisfaction extends AbstractModel {

    /**
    * 满意度值
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * 满意度标签
    */
    @SerializedName("Label")
    @Expose
    private String Label;

    /**
     * Get 满意度值 
     * @return Id 满意度值
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set 满意度值
     * @param Id 满意度值
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get 满意度标签 
     * @return Label 满意度标签
     */
    public String getLabel() {
        return this.Label;
    }

    /**
     * Set 满意度标签
     * @param Label 满意度标签
     */
    public void setLabel(String Label) {
        this.Label = Label;
    }

    public IMSatisfaction() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public IMSatisfaction(IMSatisfaction source) {
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.Label != null) {
            this.Label = new String(source.Label);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "Label", this.Label);

    }
}

