/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.bsca.v20210811.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class VulnerabilitySummary extends AbstractModel {

    /**
    * 漏洞ID
    */
    @SerializedName("VulID")
    @Expose
    private String VulID;

    /**
    * 漏洞所属CVE编号
    */
    @SerializedName("CVEID")
    @Expose
    private String CVEID;

    /**
    * 漏洞所属CNVD编号
    */
    @SerializedName("CNVDID")
    @Expose
    private String CNVDID;

    /**
    * 漏洞所属CNNVD编号
    */
    @SerializedName("CNNVDID")
    @Expose
    private String CNNVDID;

    /**
    * 漏洞名称
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * 该漏洞是否是需重点关注的漏洞
    */
    @SerializedName("IsSuggest")
    @Expose
    private Boolean IsSuggest;

    /**
    * 漏洞风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
    */
    @SerializedName("Severity")
    @Expose
    private String Severity;

    /**
    * 架构信息，如x86、ARM等，废弃，请使用ArchitectureList
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Architecture")
    @Expose
    private String [] Architecture;

    /**
    * 架构信息，如x86、ARM等
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ArchitectureList")
    @Expose
    private String [] ArchitectureList;

    /**
    * patch链接
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("PatchUrlList")
    @Expose
    private String [] PatchUrlList;

    /**
     * Get 漏洞ID 
     * @return VulID 漏洞ID
     */
    public String getVulID() {
        return this.VulID;
    }

    /**
     * Set 漏洞ID
     * @param VulID 漏洞ID
     */
    public void setVulID(String VulID) {
        this.VulID = VulID;
    }

    /**
     * Get 漏洞所属CVE编号 
     * @return CVEID 漏洞所属CVE编号
     */
    public String getCVEID() {
        return this.CVEID;
    }

    /**
     * Set 漏洞所属CVE编号
     * @param CVEID 漏洞所属CVE编号
     */
    public void setCVEID(String CVEID) {
        this.CVEID = CVEID;
    }

    /**
     * Get 漏洞所属CNVD编号 
     * @return CNVDID 漏洞所属CNVD编号
     */
    public String getCNVDID() {
        return this.CNVDID;
    }

    /**
     * Set 漏洞所属CNVD编号
     * @param CNVDID 漏洞所属CNVD编号
     */
    public void setCNVDID(String CNVDID) {
        this.CNVDID = CNVDID;
    }

    /**
     * Get 漏洞所属CNNVD编号 
     * @return CNNVDID 漏洞所属CNNVD编号
     */
    public String getCNNVDID() {
        return this.CNNVDID;
    }

    /**
     * Set 漏洞所属CNNVD编号
     * @param CNNVDID 漏洞所属CNNVD编号
     */
    public void setCNNVDID(String CNNVDID) {
        this.CNNVDID = CNNVDID;
    }

    /**
     * Get 漏洞名称 
     * @return Name 漏洞名称
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set 漏洞名称
     * @param Name 漏洞名称
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get 该漏洞是否是需重点关注的漏洞 
     * @return IsSuggest 该漏洞是否是需重点关注的漏洞
     */
    public Boolean getIsSuggest() {
        return this.IsSuggest;
    }

    /**
     * Set 该漏洞是否是需重点关注的漏洞
     * @param IsSuggest 该漏洞是否是需重点关注的漏洞
     */
    public void setIsSuggest(Boolean IsSuggest) {
        this.IsSuggest = IsSuggest;
    }

    /**
     * Get 漏洞风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li> 
     * @return Severity 漏洞风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
     */
    public String getSeverity() {
        return this.Severity;
    }

    /**
     * Set 漏洞风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
     * @param Severity 漏洞风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
     */
    public void setSeverity(String Severity) {
        this.Severity = Severity;
    }

    /**
     * Get 架构信息，如x86、ARM等，废弃，请使用ArchitectureList
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Architecture 架构信息，如x86、ARM等，废弃，请使用ArchitectureList
注意：此字段可能返回 null，表示取不到有效值。
     * @deprecated
     */
    @Deprecated
    public String [] getArchitecture() {
        return this.Architecture;
    }

    /**
     * Set 架构信息，如x86、ARM等，废弃，请使用ArchitectureList
注意：此字段可能返回 null，表示取不到有效值。
     * @param Architecture 架构信息，如x86、ARM等，废弃，请使用ArchitectureList
注意：此字段可能返回 null，表示取不到有效值。
     * @deprecated
     */
    @Deprecated
    public void setArchitecture(String [] Architecture) {
        this.Architecture = Architecture;
    }

    /**
     * Get 架构信息，如x86、ARM等
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ArchitectureList 架构信息，如x86、ARM等
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String [] getArchitectureList() {
        return this.ArchitectureList;
    }

    /**
     * Set 架构信息，如x86、ARM等
注意：此字段可能返回 null，表示取不到有效值。
     * @param ArchitectureList 架构信息，如x86、ARM等
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setArchitectureList(String [] ArchitectureList) {
        this.ArchitectureList = ArchitectureList;
    }

    /**
     * Get patch链接
注意：此字段可能返回 null，表示取不到有效值。 
     * @return PatchUrlList patch链接
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String [] getPatchUrlList() {
        return this.PatchUrlList;
    }

    /**
     * Set patch链接
注意：此字段可能返回 null，表示取不到有效值。
     * @param PatchUrlList patch链接
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setPatchUrlList(String [] PatchUrlList) {
        this.PatchUrlList = PatchUrlList;
    }

    public VulnerabilitySummary() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public VulnerabilitySummary(VulnerabilitySummary source) {
        if (source.VulID != null) {
            this.VulID = new String(source.VulID);
        }
        if (source.CVEID != null) {
            this.CVEID = new String(source.CVEID);
        }
        if (source.CNVDID != null) {
            this.CNVDID = new String(source.CNVDID);
        }
        if (source.CNNVDID != null) {
            this.CNNVDID = new String(source.CNNVDID);
        }
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.IsSuggest != null) {
            this.IsSuggest = new Boolean(source.IsSuggest);
        }
        if (source.Severity != null) {
            this.Severity = new String(source.Severity);
        }
        if (source.Architecture != null) {
            this.Architecture = new String[source.Architecture.length];
            for (int i = 0; i < source.Architecture.length; i++) {
                this.Architecture[i] = new String(source.Architecture[i]);
            }
        }
        if (source.ArchitectureList != null) {
            this.ArchitectureList = new String[source.ArchitectureList.length];
            for (int i = 0; i < source.ArchitectureList.length; i++) {
                this.ArchitectureList[i] = new String(source.ArchitectureList[i]);
            }
        }
        if (source.PatchUrlList != null) {
            this.PatchUrlList = new String[source.PatchUrlList.length];
            for (int i = 0; i < source.PatchUrlList.length; i++) {
                this.PatchUrlList[i] = new String(source.PatchUrlList[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "VulID", this.VulID);
        this.setParamSimple(map, prefix + "CVEID", this.CVEID);
        this.setParamSimple(map, prefix + "CNVDID", this.CNVDID);
        this.setParamSimple(map, prefix + "CNNVDID", this.CNNVDID);
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "IsSuggest", this.IsSuggest);
        this.setParamSimple(map, prefix + "Severity", this.Severity);
        this.setParamArraySimple(map, prefix + "Architecture.", this.Architecture);
        this.setParamArraySimple(map, prefix + "ArchitectureList.", this.ArchitectureList);
        this.setParamArraySimple(map, prefix + "PatchUrlList.", this.PatchUrlList);

    }
}

