/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.bsca.v20210811.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class VulnerabilityDetail extends AbstractModel {

    /**
    * 漏洞类别
    */
    @SerializedName("Category")
    @Expose
    private String Category;

    /**
    * 漏洞分类
    */
    @SerializedName("CategoryType")
    @Expose
    private String CategoryType;

    /**
    * 漏洞描述
    */
    @SerializedName("Description")
    @Expose
    private String Description;

    /**
    * 漏洞官方解决方案
    */
    @SerializedName("OfficialSolution")
    @Expose
    private String OfficialSolution;

    /**
    * 漏洞信息参考列表
    */
    @SerializedName("ReferenceList")
    @Expose
    private String [] ReferenceList;

    /**
    * 漏洞防御方案
    */
    @SerializedName("DefenseSolution")
    @Expose
    private String DefenseSolution;

    /**
    * 漏洞CVSSv2信息
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("CVSSv2Info")
    @Expose
    private CVSSV2Info CVSSv2Info;

    /**
    * 漏洞CVSSv3信息
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("CVSSv3Info")
    @Expose
    private CVSSV3Info CVSSv3Info;

    /**
    * 漏洞提交时间
    */
    @SerializedName("SubmitTime")
    @Expose
    private String SubmitTime;

    /**
    * 漏洞更新时间
    */
    @SerializedName("UpdateTime")
    @Expose
    private String UpdateTime;

    /**
    * CWE编号
    */
    @SerializedName("CWEID")
    @Expose
    private String CWEID;

    /**
    * 漏洞CVSSv2向量
    */
    @SerializedName("CVSSv2Vector")
    @Expose
    private String CVSSv2Vector;

    /**
    * 漏洞CVSSv3向量
    */
    @SerializedName("CVSSv3Vector")
    @Expose
    private String CVSSv3Vector;

    /**
    * 漏洞影响的组件列表，仅当查询单个漏洞时有效
    */
    @SerializedName("AffectedComponentList")
    @Expose
    private AffectedComponent [] AffectedComponentList;

    /**
     * Get 漏洞类别 
     * @return Category 漏洞类别
     */
    public String getCategory() {
        return this.Category;
    }

    /**
     * Set 漏洞类别
     * @param Category 漏洞类别
     */
    public void setCategory(String Category) {
        this.Category = Category;
    }

    /**
     * Get 漏洞分类 
     * @return CategoryType 漏洞分类
     */
    public String getCategoryType() {
        return this.CategoryType;
    }

    /**
     * Set 漏洞分类
     * @param CategoryType 漏洞分类
     */
    public void setCategoryType(String CategoryType) {
        this.CategoryType = CategoryType;
    }

    /**
     * Get 漏洞描述 
     * @return Description 漏洞描述
     */
    public String getDescription() {
        return this.Description;
    }

    /**
     * Set 漏洞描述
     * @param Description 漏洞描述
     */
    public void setDescription(String Description) {
        this.Description = Description;
    }

    /**
     * Get 漏洞官方解决方案 
     * @return OfficialSolution 漏洞官方解决方案
     */
    public String getOfficialSolution() {
        return this.OfficialSolution;
    }

    /**
     * Set 漏洞官方解决方案
     * @param OfficialSolution 漏洞官方解决方案
     */
    public void setOfficialSolution(String OfficialSolution) {
        this.OfficialSolution = OfficialSolution;
    }

    /**
     * Get 漏洞信息参考列表 
     * @return ReferenceList 漏洞信息参考列表
     */
    public String [] getReferenceList() {
        return this.ReferenceList;
    }

    /**
     * Set 漏洞信息参考列表
     * @param ReferenceList 漏洞信息参考列表
     */
    public void setReferenceList(String [] ReferenceList) {
        this.ReferenceList = ReferenceList;
    }

    /**
     * Get 漏洞防御方案 
     * @return DefenseSolution 漏洞防御方案
     */
    public String getDefenseSolution() {
        return this.DefenseSolution;
    }

    /**
     * Set 漏洞防御方案
     * @param DefenseSolution 漏洞防御方案
     */
    public void setDefenseSolution(String DefenseSolution) {
        this.DefenseSolution = DefenseSolution;
    }

    /**
     * Get 漏洞CVSSv2信息
注意：此字段可能返回 null，表示取不到有效值。 
     * @return CVSSv2Info 漏洞CVSSv2信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public CVSSV2Info getCVSSv2Info() {
        return this.CVSSv2Info;
    }

    /**
     * Set 漏洞CVSSv2信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param CVSSv2Info 漏洞CVSSv2信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setCVSSv2Info(CVSSV2Info CVSSv2Info) {
        this.CVSSv2Info = CVSSv2Info;
    }

    /**
     * Get 漏洞CVSSv3信息
注意：此字段可能返回 null，表示取不到有效值。 
     * @return CVSSv3Info 漏洞CVSSv3信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public CVSSV3Info getCVSSv3Info() {
        return this.CVSSv3Info;
    }

    /**
     * Set 漏洞CVSSv3信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param CVSSv3Info 漏洞CVSSv3信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setCVSSv3Info(CVSSV3Info CVSSv3Info) {
        this.CVSSv3Info = CVSSv3Info;
    }

    /**
     * Get 漏洞提交时间 
     * @return SubmitTime 漏洞提交时间
     */
    public String getSubmitTime() {
        return this.SubmitTime;
    }

    /**
     * Set 漏洞提交时间
     * @param SubmitTime 漏洞提交时间
     */
    public void setSubmitTime(String SubmitTime) {
        this.SubmitTime = SubmitTime;
    }

    /**
     * Get 漏洞更新时间 
     * @return UpdateTime 漏洞更新时间
     */
    public String getUpdateTime() {
        return this.UpdateTime;
    }

    /**
     * Set 漏洞更新时间
     * @param UpdateTime 漏洞更新时间
     */
    public void setUpdateTime(String UpdateTime) {
        this.UpdateTime = UpdateTime;
    }

    /**
     * Get CWE编号 
     * @return CWEID CWE编号
     */
    public String getCWEID() {
        return this.CWEID;
    }

    /**
     * Set CWE编号
     * @param CWEID CWE编号
     */
    public void setCWEID(String CWEID) {
        this.CWEID = CWEID;
    }

    /**
     * Get 漏洞CVSSv2向量 
     * @return CVSSv2Vector 漏洞CVSSv2向量
     */
    public String getCVSSv2Vector() {
        return this.CVSSv2Vector;
    }

    /**
     * Set 漏洞CVSSv2向量
     * @param CVSSv2Vector 漏洞CVSSv2向量
     */
    public void setCVSSv2Vector(String CVSSv2Vector) {
        this.CVSSv2Vector = CVSSv2Vector;
    }

    /**
     * Get 漏洞CVSSv3向量 
     * @return CVSSv3Vector 漏洞CVSSv3向量
     */
    public String getCVSSv3Vector() {
        return this.CVSSv3Vector;
    }

    /**
     * Set 漏洞CVSSv3向量
     * @param CVSSv3Vector 漏洞CVSSv3向量
     */
    public void setCVSSv3Vector(String CVSSv3Vector) {
        this.CVSSv3Vector = CVSSv3Vector;
    }

    /**
     * Get 漏洞影响的组件列表，仅当查询单个漏洞时有效 
     * @return AffectedComponentList 漏洞影响的组件列表，仅当查询单个漏洞时有效
     */
    public AffectedComponent [] getAffectedComponentList() {
        return this.AffectedComponentList;
    }

    /**
     * Set 漏洞影响的组件列表，仅当查询单个漏洞时有效
     * @param AffectedComponentList 漏洞影响的组件列表，仅当查询单个漏洞时有效
     */
    public void setAffectedComponentList(AffectedComponent [] AffectedComponentList) {
        this.AffectedComponentList = AffectedComponentList;
    }

    public VulnerabilityDetail() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public VulnerabilityDetail(VulnerabilityDetail source) {
        if (source.Category != null) {
            this.Category = new String(source.Category);
        }
        if (source.CategoryType != null) {
            this.CategoryType = new String(source.CategoryType);
        }
        if (source.Description != null) {
            this.Description = new String(source.Description);
        }
        if (source.OfficialSolution != null) {
            this.OfficialSolution = new String(source.OfficialSolution);
        }
        if (source.ReferenceList != null) {
            this.ReferenceList = new String[source.ReferenceList.length];
            for (int i = 0; i < source.ReferenceList.length; i++) {
                this.ReferenceList[i] = new String(source.ReferenceList[i]);
            }
        }
        if (source.DefenseSolution != null) {
            this.DefenseSolution = new String(source.DefenseSolution);
        }
        if (source.CVSSv2Info != null) {
            this.CVSSv2Info = new CVSSV2Info(source.CVSSv2Info);
        }
        if (source.CVSSv3Info != null) {
            this.CVSSv3Info = new CVSSV3Info(source.CVSSv3Info);
        }
        if (source.SubmitTime != null) {
            this.SubmitTime = new String(source.SubmitTime);
        }
        if (source.UpdateTime != null) {
            this.UpdateTime = new String(source.UpdateTime);
        }
        if (source.CWEID != null) {
            this.CWEID = new String(source.CWEID);
        }
        if (source.CVSSv2Vector != null) {
            this.CVSSv2Vector = new String(source.CVSSv2Vector);
        }
        if (source.CVSSv3Vector != null) {
            this.CVSSv3Vector = new String(source.CVSSv3Vector);
        }
        if (source.AffectedComponentList != null) {
            this.AffectedComponentList = new AffectedComponent[source.AffectedComponentList.length];
            for (int i = 0; i < source.AffectedComponentList.length; i++) {
                this.AffectedComponentList[i] = new AffectedComponent(source.AffectedComponentList[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Category", this.Category);
        this.setParamSimple(map, prefix + "CategoryType", this.CategoryType);
        this.setParamSimple(map, prefix + "Description", this.Description);
        this.setParamSimple(map, prefix + "OfficialSolution", this.OfficialSolution);
        this.setParamArraySimple(map, prefix + "ReferenceList.", this.ReferenceList);
        this.setParamSimple(map, prefix + "DefenseSolution", this.DefenseSolution);
        this.setParamObj(map, prefix + "CVSSv2Info.", this.CVSSv2Info);
        this.setParamObj(map, prefix + "CVSSv3Info.", this.CVSSv3Info);
        this.setParamSimple(map, prefix + "SubmitTime", this.SubmitTime);
        this.setParamSimple(map, prefix + "UpdateTime", this.UpdateTime);
        this.setParamSimple(map, prefix + "CWEID", this.CWEID);
        this.setParamSimple(map, prefix + "CVSSv2Vector", this.CVSSv2Vector);
        this.setParamSimple(map, prefix + "CVSSv3Vector", this.CVSSv3Vector);
        this.setParamArrayObj(map, prefix + "AffectedComponentList.", this.AffectedComponentList);

    }
}

