/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.bsca.v20210811.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeKBComponentVulnerabilityResponse extends AbstractModel {

    /**
    * 漏洞信息列表
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("VulnerabilityList")
    @Expose
    private ComponentVulnerabilityUnion [] VulnerabilityList;

    /**
    * 组件purl
    */
    @SerializedName("PURL")
    @Expose
    private PURL PURL;

    /**
    * 推荐版本，最小无高危/严重漏洞的版本。无法升级到安全版本时的备选方案。
    */
    @SerializedName("RecommendedVersion")
    @Expose
    private String RecommendedVersion;

    /**
    * 安全版本（首选），最小无漏洞的版本。当无法升级到安全版本时可考虑使用推荐版本。
    */
    @SerializedName("SecureVersion")
    @Expose
    private String SecureVersion;

    /**
    * 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 漏洞信息列表
注意：此字段可能返回 null，表示取不到有效值。 
     * @return VulnerabilityList 漏洞信息列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public ComponentVulnerabilityUnion [] getVulnerabilityList() {
        return this.VulnerabilityList;
    }

    /**
     * Set 漏洞信息列表
注意：此字段可能返回 null，表示取不到有效值。
     * @param VulnerabilityList 漏洞信息列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setVulnerabilityList(ComponentVulnerabilityUnion [] VulnerabilityList) {
        this.VulnerabilityList = VulnerabilityList;
    }

    /**
     * Get 组件purl 
     * @return PURL 组件purl
     */
    public PURL getPURL() {
        return this.PURL;
    }

    /**
     * Set 组件purl
     * @param PURL 组件purl
     */
    public void setPURL(PURL PURL) {
        this.PURL = PURL;
    }

    /**
     * Get 推荐版本，最小无高危/严重漏洞的版本。无法升级到安全版本时的备选方案。 
     * @return RecommendedVersion 推荐版本，最小无高危/严重漏洞的版本。无法升级到安全版本时的备选方案。
     */
    public String getRecommendedVersion() {
        return this.RecommendedVersion;
    }

    /**
     * Set 推荐版本，最小无高危/严重漏洞的版本。无法升级到安全版本时的备选方案。
     * @param RecommendedVersion 推荐版本，最小无高危/严重漏洞的版本。无法升级到安全版本时的备选方案。
     */
    public void setRecommendedVersion(String RecommendedVersion) {
        this.RecommendedVersion = RecommendedVersion;
    }

    /**
     * Get 安全版本（首选），最小无漏洞的版本。当无法升级到安全版本时可考虑使用推荐版本。 
     * @return SecureVersion 安全版本（首选），最小无漏洞的版本。当无法升级到安全版本时可考虑使用推荐版本。
     */
    public String getSecureVersion() {
        return this.SecureVersion;
    }

    /**
     * Set 安全版本（首选），最小无漏洞的版本。当无法升级到安全版本时可考虑使用推荐版本。
     * @param SecureVersion 安全版本（首选），最小无漏洞的版本。当无法升级到安全版本时可考虑使用推荐版本。
     */
    public void setSecureVersion(String SecureVersion) {
        this.SecureVersion = SecureVersion;
    }

    /**
     * Get 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeKBComponentVulnerabilityResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeKBComponentVulnerabilityResponse(DescribeKBComponentVulnerabilityResponse source) {
        if (source.VulnerabilityList != null) {
            this.VulnerabilityList = new ComponentVulnerabilityUnion[source.VulnerabilityList.length];
            for (int i = 0; i < source.VulnerabilityList.length; i++) {
                this.VulnerabilityList[i] = new ComponentVulnerabilityUnion(source.VulnerabilityList[i]);
            }
        }
        if (source.PURL != null) {
            this.PURL = new PURL(source.PURL);
        }
        if (source.RecommendedVersion != null) {
            this.RecommendedVersion = new String(source.RecommendedVersion);
        }
        if (source.SecureVersion != null) {
            this.SecureVersion = new String(source.SecureVersion);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "VulnerabilityList.", this.VulnerabilityList);
        this.setParamObj(map, prefix + "PURL.", this.PURL);
        this.setParamSimple(map, prefix + "RecommendedVersion", this.RecommendedVersion);
        this.setParamSimple(map, prefix + "SecureVersion", this.SecureVersion);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

