/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.flink.table;

import com.selectdb.flink.cfg.SelectdbExecutionOptions;
import com.selectdb.flink.cfg.SelectdbOptions;
import com.selectdb.flink.sink.EscapeHandler;
import com.selectdb.flink.sink.SelectdbSink;
import com.selectdb.flink.sink.writer.RowDataSerializer;
import java.util.Properties;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectdbDynamicTableSink
implements DynamicTableSink {
    private static final Logger LOG = LoggerFactory.getLogger(SelectdbDynamicTableSink.class);
    private final SelectdbOptions options;
    private final SelectdbExecutionOptions executionOptions;
    private final TableSchema tableSchema;
    private final Integer sinkParallelism;

    public SelectdbDynamicTableSink(SelectdbOptions options, SelectdbExecutionOptions executionOptions, TableSchema tableSchema, Integer sinkParallelism) {
        this.options = options;
        this.executionOptions = executionOptions;
        this.tableSchema = tableSchema;
        this.sinkParallelism = sinkParallelism;
    }

    public ChangelogMode getChangelogMode(ChangelogMode changelogMode) {
        if (this.executionOptions.getIgnoreUpdateBefore().booleanValue()) {
            return ChangelogMode.upsert();
        }
        return ChangelogMode.all();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        EscapeHandler.handleEscape(this.executionOptions.getLoadProps());
        Properties loadProperties = this.executionOptions.getLoadProps();
        RowDataSerializer.Builder serializerBuilder = RowDataSerializer.builder();
        serializerBuilder.setFieldNames(this.tableSchema.getFieldNames()).setFieldType(this.tableSchema.getFieldDataTypes()).setType(loadProperties.getProperty("file.type", "csv")).enableDelete(this.executionOptions.getDeletable()).setFieldDelimiter(loadProperties.getProperty("file.column_separator", "\t"));
        SelectdbSink.Builder selectdbSinkBuilder = SelectdbSink.builder();
        selectdbSinkBuilder.setSelectdbOptions(this.options).setSelectdbExecutionOptions(this.executionOptions).setSerializer(serializerBuilder.build());
        return SinkProvider.of(selectdbSinkBuilder.build(), (Integer)this.sinkParallelism);
    }

    public DynamicTableSink copy() {
        return new SelectdbDynamicTableSink(this.options, this.executionOptions, this.tableSchema, this.sinkParallelism);
    }

    public String asSummaryString() {
        return "Selectdb Table Sink";
    }
}

