/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.flink.table;

import com.selectdb.flink.cfg.SelectdbExecutionOptions;
import com.selectdb.flink.cfg.SelectdbOptions;
import com.selectdb.flink.table.SelectdbConnectorOptions;
import com.selectdb.flink.table.SelectdbDynamicTableSink;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.utils.TableSchemaUtils;

public final class SelectdbDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public String factoryIdentifier() {
        return "selectdb";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(SelectdbConnectorOptions.LOAD_URL);
        options.add(SelectdbConnectorOptions.JDBC_URL);
        options.add(SelectdbConnectorOptions.CLUSTER_NAME);
        options.add(SelectdbConnectorOptions.TABLE_IDENTIFIER);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(SelectdbConnectorOptions.LOAD_URL);
        options.add(SelectdbConnectorOptions.JDBC_URL);
        options.add(SelectdbConnectorOptions.CLUSTER_NAME);
        options.add(SelectdbConnectorOptions.TABLE_IDENTIFIER);
        options.add(SelectdbConnectorOptions.USERNAME);
        options.add(SelectdbConnectorOptions.PASSWORD);
        options.add(SelectdbConnectorOptions.SINK_MAX_RETRIES);
        options.add(SelectdbConnectorOptions.SINK_ENABLE_DELETE);
        options.add(SelectdbConnectorOptions.SINK_BUFFER_SIZE);
        options.add(SelectdbConnectorOptions.SINK_BUFFER_COUNT);
        options.add(SelectdbConnectorOptions.SINK_FLUSH_QUEUE_SIZE);
        options.add(SelectdbConnectorOptions.SINK_PARALLELISM);
        options.add(SelectdbConnectorOptions.SINK_IGNORE_UPDATE_BEFORE);
        return options;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        return null;
    }

    private SelectdbOptions getSelectdbOptions(ReadableConfig readableConfig) {
        String loadUrl = (String)readableConfig.get(SelectdbConnectorOptions.LOAD_URL);
        String jdbcUrl = (String)readableConfig.get(SelectdbConnectorOptions.JDBC_URL);
        String clusterName = (String)readableConfig.get(SelectdbConnectorOptions.CLUSTER_NAME);
        SelectdbOptions.Builder builder = SelectdbOptions.builder().setLoadUrl(loadUrl).setJdbcUrl(jdbcUrl).setClusterName(clusterName).setTableIdentifier((String)readableConfig.get(SelectdbConnectorOptions.TABLE_IDENTIFIER));
        readableConfig.getOptional(SelectdbConnectorOptions.USERNAME).ifPresent(builder::setUsername);
        readableConfig.getOptional(SelectdbConnectorOptions.PASSWORD).ifPresent(builder::setPassword);
        return builder.build();
    }

    private SelectdbExecutionOptions getSelectdbExecutionOptions(ReadableConfig readableConfig, Properties loadProps) {
        SelectdbExecutionOptions.Builder builder = SelectdbExecutionOptions.builder();
        builder.setMaxRetries((Integer)readableConfig.get(SelectdbConnectorOptions.SINK_MAX_RETRIES));
        builder.setBufferSize((Integer)readableConfig.get(SelectdbConnectorOptions.SINK_BUFFER_SIZE));
        builder.setBufferCount((Integer)readableConfig.get(SelectdbConnectorOptions.SINK_BUFFER_COUNT));
        builder.setLoadProps(loadProps);
        builder.setDeletable((Boolean)readableConfig.get(SelectdbConnectorOptions.SINK_ENABLE_DELETE));
        builder.setFlushQueueSize((Integer)readableConfig.get(SelectdbConnectorOptions.SINK_FLUSH_QUEUE_SIZE));
        builder.setIgnoreUpdateBefore((Boolean)readableConfig.get(SelectdbConnectorOptions.SINK_IGNORE_UPDATE_BEFORE));
        return builder.build();
    }

    private Properties getLoadProps(Map<String, String> tableOptions) {
        Properties streamLoadProp = new Properties();
        for (Map.Entry<String, String> entry : tableOptions.entrySet()) {
            if (!entry.getKey().startsWith("sink.properties.")) continue;
            String subKey = entry.getKey().substring("sink.properties.".length());
            streamLoadProp.put(subKey, entry.getValue());
        }
        return streamLoadProp;
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"sink.properties."});
        Integer parallelism = (Integer)helper.getOptions().get(SelectdbConnectorOptions.SINK_PARALLELISM);
        Properties streamLoadProp = this.getLoadProps(context.getCatalogTable().getOptions());
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getCatalogTable().getSchema());
        return new SelectdbDynamicTableSink(this.getSelectdbOptions(helper.getOptions()), this.getSelectdbExecutionOptions(helper.getOptions(), streamLoadProp), physicalSchema, parallelism);
    }
}

