/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.flink.sink.writer;

import com.selectdb.flink.converter.SelectdbRowConverter;
import com.selectdb.flink.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.selectdb.flink.sink.writer.SelectdbRecordSerializer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.StringJoiner;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class RowDataSerializer
implements SelectdbRecordSerializer<RowData> {
    private static final long serialVersionUID = 1L;
    String[] fieldNames;
    String type;
    private ObjectMapper objectMapper = new ObjectMapper();
    private final String fieldDelimiter;
    private final boolean enableDelete;
    private final SelectdbRowConverter rowConverter;

    private RowDataSerializer(String[] fieldNames, DataType[] dataTypes, String type, String fieldDelimiter, boolean enableDelete) {
        this.fieldNames = fieldNames;
        this.type = type;
        this.fieldDelimiter = fieldDelimiter;
        this.enableDelete = enableDelete;
        this.rowConverter = new SelectdbRowConverter(dataTypes);
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public byte[] serialize(RowData record) throws IOException {
        String valString;
        int maxIndex = Math.min(record.getArity(), this.fieldNames.length);
        if ("json".equals(this.type)) {
            valString = this.buildJsonString(record, maxIndex);
        } else if ("csv".equals(this.type)) {
            valString = this.buildCSVString(record, maxIndex);
        } else {
            throw new IllegalArgumentException("The type " + this.type + " is not supported!");
        }
        return valString.getBytes(StandardCharsets.UTF_8);
    }

    public String buildJsonString(RowData record, int maxIndex) throws IOException {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (int fieldIndex = 0; fieldIndex < maxIndex; ++fieldIndex) {
            Object field = this.rowConverter.convertExternal(record, fieldIndex);
            String value = field != null ? field.toString() : null;
            valueMap.put(this.fieldNames[fieldIndex], value);
        }
        if (this.enableDelete) {
            valueMap.put("__DORIS_DELETE_SIGN__", this.parseDeleteSign(record.getRowKind()));
        }
        return this.objectMapper.writeValueAsString(valueMap);
    }

    public String buildCSVString(RowData record, int maxIndex) throws IOException {
        StringJoiner joiner = new StringJoiner(this.fieldDelimiter);
        for (int fieldIndex = 0; fieldIndex < maxIndex; ++fieldIndex) {
            Object field = this.rowConverter.convertExternal(record, fieldIndex);
            String value = field != null ? field.toString() : "\\N";
            joiner.add(value);
        }
        if (this.enableDelete) {
            joiner.add(this.parseDeleteSign(record.getRowKind()));
        }
        return joiner.toString();
    }

    public String parseDeleteSign(RowKind rowKind) {
        if (RowKind.INSERT.equals((Object)rowKind) || RowKind.UPDATE_AFTER.equals((Object)rowKind)) {
            return "0";
        }
        if (RowKind.DELETE.equals((Object)rowKind) || RowKind.UPDATE_BEFORE.equals((Object)rowKind)) {
            return "1";
        }
        throw new IllegalArgumentException("Unrecognized row kind:" + rowKind.toString());
    }

    @Override
    public void close() throws IOException {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String[] fieldNames;
        private DataType[] dataTypes;
        private String type;
        private String fieldDelimiter;
        private boolean deletable;

        public Builder setFieldNames(String[] fieldNames) {
            this.fieldNames = fieldNames;
            return this;
        }

        public Builder setFieldType(DataType[] dataTypes) {
            this.dataTypes = dataTypes;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public Builder enableDelete(boolean deletable) {
            this.deletable = deletable;
            return this;
        }

        public RowDataSerializer build() {
            Preconditions.checkNotNull((Object)this.type);
            Preconditions.checkNotNull((Object)this.dataTypes);
            Preconditions.checkNotNull((Object)this.fieldNames);
            return new RowDataSerializer(this.fieldNames, this.dataTypes, this.type, this.fieldDelimiter, this.deletable);
        }
    }
}

