/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.flink.sink;

import com.selectdb.flink.cfg.SelectdbExecutionOptions;
import com.selectdb.flink.cfg.SelectdbOptions;
import com.selectdb.flink.sink.EscapeHandler;
import com.selectdb.flink.sink.SelectdbCommittable;
import com.selectdb.flink.sink.SelectdbCommittableSerializer;
import com.selectdb.flink.sink.committer.SelectdbCommitter;
import com.selectdb.flink.sink.writer.SelectdbRecordSerializer;
import com.selectdb.flink.sink.writer.SelectdbWriter;
import com.selectdb.flink.sink.writer.SelectdbWriterState;
import com.selectdb.flink.sink.writer.SelectdbWriterStateSerializer;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.connector.sink.SinkWriter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

public class SelectdbSink<IN>
implements Sink<IN, SelectdbCommittable, SelectdbWriterState, SelectdbCommittable> {
    private final SelectdbOptions selectdbOptions;
    private final SelectdbExecutionOptions selectdbExecutionOptions;
    private final SelectdbRecordSerializer<IN> serializer;

    public SelectdbSink(SelectdbOptions selectdbOptions, SelectdbExecutionOptions selectdbExecutionOptions, SelectdbRecordSerializer<IN> serializer) {
        this.selectdbOptions = selectdbOptions;
        this.selectdbExecutionOptions = selectdbExecutionOptions;
        this.serializer = serializer;
    }

    public SinkWriter<IN, SelectdbCommittable, SelectdbWriterState> createWriter(Sink.InitContext initContext, List<SelectdbWriterState> state) throws IOException {
        SelectdbWriter<IN> selectdbWriter = new SelectdbWriter<IN>(initContext, state, this.serializer, this.selectdbOptions, this.selectdbExecutionOptions);
        selectdbWriter.initializeLoad(state);
        return selectdbWriter;
    }

    public Optional<SimpleVersionedSerializer<SelectdbWriterState>> getWriterStateSerializer() {
        return Optional.of(new SelectdbWriterStateSerializer());
    }

    public Optional<Committer<SelectdbCommittable>> createCommitter() throws IOException {
        return Optional.of(new SelectdbCommitter(this.selectdbOptions, this.selectdbExecutionOptions.getMaxRetries()));
    }

    public Optional<GlobalCommitter<SelectdbCommittable, SelectdbCommittable>> createGlobalCommitter() throws IOException {
        return Optional.empty();
    }

    public Optional<SimpleVersionedSerializer<SelectdbCommittable>> getCommittableSerializer() {
        return Optional.of(new SelectdbCommittableSerializer());
    }

    public Optional<SimpleVersionedSerializer<SelectdbCommittable>> getGlobalCommittableSerializer() {
        return Optional.empty();
    }

    public static <IN> Builder<IN> builder() {
        return new Builder();
    }

    public static class Builder<IN> {
        private SelectdbOptions selectdbOptions;
        private SelectdbExecutionOptions selectdbExecutionOptions;
        private SelectdbRecordSerializer<IN> serializer;

        public Builder<IN> setSelectdbOptions(SelectdbOptions selectdbOptions) {
            this.selectdbOptions = selectdbOptions;
            return this;
        }

        public Builder<IN> setSelectdbExecutionOptions(SelectdbExecutionOptions selectdbExecutionOptions) {
            this.selectdbExecutionOptions = selectdbExecutionOptions;
            return this;
        }

        public Builder<IN> setSerializer(SelectdbRecordSerializer<IN> serializer) {
            this.serializer = serializer;
            return this;
        }

        public SelectdbSink<IN> build() {
            Preconditions.checkNotNull((Object)this.selectdbOptions);
            Preconditions.checkNotNull((Object)this.selectdbExecutionOptions);
            Preconditions.checkNotNull(this.serializer);
            EscapeHandler.handleEscape(this.selectdbExecutionOptions.getLoadProps());
            return new SelectdbSink<IN>(this.selectdbOptions, this.selectdbExecutionOptions, this.serializer);
        }
    }
}

