/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.flink.sink;

import com.selectdb.flink.cfg.SelectdbExecutionOptions;
import com.selectdb.flink.cfg.SelectdbOptions;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;

public class CopySQLBuilder {
    private static final String COPY_SYNC = "copy.async";
    private static final String COPY_DELETE = "copy.use_delete_sign";
    private final SelectdbOptions selectdbOptions;
    private final SelectdbExecutionOptions executionOptions;
    private final List<String> fileList;
    private Properties properties;

    public CopySQLBuilder(SelectdbOptions selectdbOptions, SelectdbExecutionOptions executionOptions, List<String> fileList) {
        this.selectdbOptions = selectdbOptions;
        this.executionOptions = executionOptions;
        this.fileList = fileList;
        this.properties = executionOptions.getLoadProps();
    }

    public String buildCopySQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("COPY INTO ").append(this.selectdbOptions.getTableIdentifier()).append(" FROM @~('{").append(String.join((CharSequence)",", this.fileList)).append("}') ").append("PROPERTIES (");
        this.properties.put(COPY_SYNC, (Object)false);
        if (this.executionOptions.getDeletable().booleanValue()) {
            this.properties.put(COPY_DELETE, (Object)true);
        }
        StringJoiner props = new StringJoiner(",");
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            String prop = String.format("'%s'='%s'", key, value);
            props.add(prop);
        }
        sb.append(props).append(")");
        return sb.toString();
    }
}

