/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.flink.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.util.Preconditions;

public class SelectdbRowConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DeserializationConverter[] deserializationConverters;
    private final SerializationConverter[] serializationConverters;

    public SelectdbRowConverter(RowType rowType) {
        Preconditions.checkNotNull((Object)rowType);
        this.deserializationConverters = new DeserializationConverter[rowType.getFieldCount()];
        this.serializationConverters = new SerializationConverter[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            this.deserializationConverters[i] = this.createNullableInternalConverter(rowType.getTypeAt(i));
            this.serializationConverters[i] = this.createNullableExternalConverter(rowType.getTypeAt(i));
        }
    }

    public SelectdbRowConverter(DataType[] dataTypes) {
        Preconditions.checkNotNull((Object)dataTypes);
        this.deserializationConverters = new DeserializationConverter[dataTypes.length];
        this.serializationConverters = new SerializationConverter[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            LogicalType logicalType = dataTypes[i].getLogicalType();
            this.deserializationConverters[i] = this.createNullableInternalConverter(logicalType);
            this.serializationConverters[i] = this.createNullableExternalConverter(logicalType);
        }
    }

    public GenericRowData convertInternal(List record) {
        GenericRowData rowData = new GenericRowData(this.deserializationConverters.length);
        for (int i = 0; i < this.deserializationConverters.length; ++i) {
            rowData.setField(i, this.deserializationConverters[i].deserialize(record.get(i)));
        }
        return rowData;
    }

    public Object convertExternal(RowData rowData, int index) {
        return this.serializationConverters[index].serialize(index, rowData);
    }

    protected DeserializationConverter createNullableInternalConverter(LogicalType type) {
        return this.wrapIntoNullableInternalConverter(this.createInternalConverter(type));
    }

    protected DeserializationConverter wrapIntoNullableInternalConverter(DeserializationConverter deserializationConverter) {
        return val -> {
            if (val == null) {
                return null;
            }
            return deserializationConverter.deserialize(val);
        };
    }

    protected SerializationConverter createNullableExternalConverter(LogicalType type) {
        return this.wrapIntoNullableExternalConverter(this.createExternalConverter(type));
    }

    protected SerializationConverter wrapIntoNullableExternalConverter(SerializationConverter serializationConverter) {
        return (index, val) -> {
            if (val == null || val.isNullAt(index)) {
                return null;
            }
            return serializationConverter.serialize(index, val);
        };
    }

    protected DeserializationConverter createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return val -> null;
            }
            case BOOLEAN: 
            case FLOAT: 
            case DOUBLE: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return val -> val;
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                return val -> DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)val), (int)precision, (int)scale);
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return val -> {
                    if (val instanceof LocalDateTime) {
                        return TimestampData.fromLocalDateTime((LocalDateTime)((LocalDateTime)val));
                    }
                    throw new UnsupportedOperationException("timestamp type must be java.time.LocalDateTime, the actual type is: " + val.getClass().getName());
                };
            }
            case DATE: {
                return val -> {
                    if (val instanceof LocalDate) {
                        return (int)((LocalDate)val).toEpochDay();
                    }
                    throw new UnsupportedOperationException("timestamp type must be java.time.LocalDate, the actual type is: " + val.getClass());
                };
            }
            case CHAR: 
            case VARCHAR: {
                return val -> StringData.fromString((String)((String)val));
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    protected SerializationConverter createExternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return (index, val) -> null;
            }
            case CHAR: 
            case VARCHAR: {
                return (index, val) -> val.getString(index);
            }
            case BOOLEAN: {
                return (index, val) -> val.getBoolean(index);
            }
            case BINARY: 
            case VARBINARY: {
                return (index, val) -> val.getBinary(index);
            }
            case DECIMAL: {
                int decimalPrecision = ((DecimalType)type).getPrecision();
                int decimalScale = ((DecimalType)type).getScale();
                return (index, val) -> val.getDecimal(index, decimalPrecision, decimalScale);
            }
            case TINYINT: {
                return (index, val) -> val.getByte(index);
            }
            case SMALLINT: {
                return (index, val) -> val.getShort(index);
            }
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: 
            case INTEGER: {
                return (index, val) -> val.getInt(index);
            }
            case BIGINT: {
                return (index, val) -> val.getLong(index);
            }
            case FLOAT: {
                return (index, val) -> Float.valueOf(val.getFloat(index));
            }
            case DOUBLE: {
                return (index, val) -> val.getDouble(index);
            }
            case DATE: {
                return (index, val) -> Date.valueOf(LocalDate.ofEpochDay(val.getInt(index)));
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)type).getPrecision();
                return (index, val) -> val.getTimestamp(index, timestampPrecision).toTimestamp();
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int localP = ((LocalZonedTimestampType)type).getPrecision();
                return (index, val) -> val.getTimestamp(index, localP).toTimestamp();
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                int zonedP = ((ZonedTimestampType)type).getPrecision();
                return (index, val) -> val.getTimestamp(index, zonedP).toTimestamp();
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    @FunctionalInterface
    static interface SerializationConverter
    extends Serializable {
        public Object serialize(int var1, RowData var2);
    }

    @FunctionalInterface
    static interface DeserializationConverter
    extends Serializable {
        public Object deserialize(Object var1);
    }
}

