/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.flink.connection;

import com.selectdb.flink.cfg.SelectdbConnectionOptions;
import com.selectdb.flink.connection.JdbcConnectionProvider;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJdbcConnectionProvider
implements JdbcConnectionProvider,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleJdbcConnectionProvider.class);
    private static final String JDBC_URL_TEMPLATE = "jdbc:mysql://%s";
    private static final long serialVersionUID = 1L;
    private final SelectdbConnectionOptions options;
    private transient Connection connection;

    public SimpleJdbcConnectionProvider(SelectdbConnectionOptions options) {
        this.options = options;
    }

    @Override
    public Connection getOrEstablishConnection() throws ClassNotFoundException, SQLException {
        if (this.connection != null && !this.connection.isClosed() && this.connection.isValid(10000)) {
            return this.connection;
        }
        try {
            Class.forName(this.options.getCjDriverName());
        }
        catch (ClassNotFoundException ex) {
            LOG.warn("can not found class com.mysql.cj.jdbc.Driver, use class com.mysql.jdbc.Driver");
            Class.forName(this.options.getDriverName());
        }
        String jdbcUrl = String.format(JDBC_URL_TEMPLATE, this.options.getJdbcUrl());
        this.connection = !Objects.isNull(this.options.getUsername()) ? DriverManager.getConnection(jdbcUrl, this.options.getUsername(), this.options.getPassword()) : DriverManager.getConnection(jdbcUrl);
        return this.connection;
    }

    @Override
    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOG.warn("JDBC connection close failed.", (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }
}

