/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.flink.cfg;

import com.selectdb.flink.cfg.SelectdbConnectionOptions;
import org.apache.flink.util.Preconditions;

public class SelectdbOptions
extends SelectdbConnectionOptions {
    private static final long serialVersionUID = 1L;
    private String tableIdentifier;

    public SelectdbOptions(String loadUrl, String jdbcUrl, String clusterName, String username, String password, String tableIdentifier) {
        super(loadUrl, jdbcUrl, clusterName, username, password);
        this.tableIdentifier = tableIdentifier;
    }

    public String getTableIdentifier() {
        return this.tableIdentifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String loadUrl;
        private String jdbcUrl;
        private String clusterName;
        private String username;
        private String password;
        private String tableIdentifier;

        public Builder setTableIdentifier(String tableIdentifier) {
            this.tableIdentifier = tableIdentifier;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setLoadUrl(String loadUrl) {
            this.loadUrl = loadUrl;
            return this;
        }

        public Builder setJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public Builder setClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public SelectdbOptions build() {
            Preconditions.checkNotNull((Object)this.loadUrl, (String)"No loadUrl supplied.");
            Preconditions.checkNotNull((Object)this.jdbcUrl, (String)"No jdbcUrl supplied.");
            Preconditions.checkNotNull((Object)this.clusterName, (String)"No clusterName supplied.");
            Preconditions.checkNotNull((Object)this.tableIdentifier, (String)"No tableIdentifier supplied.");
            return new SelectdbOptions(this.loadUrl, this.jdbcUrl, this.clusterName, this.username, this.password, this.tableIdentifier);
        }
    }
}

