/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.qiniu.util.StringMap;
import java.lang.reflect.Type;
import java.util.Map;

public final class Json {
    private Json() {
    }

    public static String encode(StringMap map) {
        return new Gson().toJson(map.map());
    }

    public static String encode(Object obj) {
        return new GsonBuilder().serializeNulls().create().toJson(obj);
    }

    public static <T> T decode(String json, Class<T> classOfT) {
        return (T)new Gson().fromJson(json, classOfT);
    }

    public static <T> T decode(JsonElement jsonElement, Class<T> clazz) {
        Gson gson = new Gson();
        return (T)gson.fromJson(jsonElement, clazz);
    }

    public static StringMap decode(String json) {
        Type t = new TypeToken<Map<String, Object>>(){}.getType();
        Map x = (Map)new Gson().fromJson(json, t);
        return new StringMap(x);
    }

    public static Object[] decodeArray(String json) {
        Type t = new TypeToken<Object[]>(){}.getType();
        return (Object[])new Gson().fromJson(json, t);
    }
}

