package com.qcloud.cos.model.ciModel.metaInsight;

import com.qcloud.cos.internal.CIServiceRequest;


public class CreateDatasetRequest extends CIServiceRequest {

    /**
     *数据集名称，同一个账户下唯一。命名规则如下： 长度为1~32字符。 只能包含小写英文字母，数字，短划线（-）。 必须以英文字母和数字开头。;是否必传：是
     */
    private String datasetName;

    /**
     *数据集描述信息。长度为1~256个英文或中文字符，默认值为空。;是否必传：否
     */
    private String description;

    /**
     *指模板，在建立元数据索引时，后端将根据模板来决定收集哪些元数据。每个模板都包含一个或多个算子，不同的算子表示不同的元数据。
     * 目前支持的模板： Official:DefaultEmptyId：默认为空的模板，表示不进行元数据的采集。
     * Official:COSBasicMeta：基础信息模板，包含 COS 文件基础元信息算子，表示采集 COS 文件的名称、类型、ACL等基础元信息数据。
     * Official:FaceSearch：人脸检索模板，包含人脸检索、COS 文件基础元信息算子。
     * Official:ImageSearch：图像检索模板，包含图像检索、COS 文件基础元信息算子。;
     * 是否必传：否
     */
    private String templateId;

    public String getDatasetName() { return datasetName; }

    public void setDatasetName(String datasetName) { this.datasetName = datasetName; }

    public String getDescription() { return description; }

    public void setDescription(String description) { this.description = description; }

    public String getTemplateId() { return templateId; }

    public void setTemplateId(String templateId) { this.templateId = templateId; }

    


}
