/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Counted;
import com.palominolabs.metrics.guice.CountedInterceptor;
import com.palominolabs.metrics.guice.DeclaredMethodsTypeListener;
import com.palominolabs.metrics.guice.MetricNamer;
import com.palominolabs.metrics.guice.annotation.AnnotationResolver;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;

public class CountedListener
extends DeclaredMethodsTypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;

    public CountedListener(MetricRegistry metricRegistry, MetricNamer metricNamer, AnnotationResolver annotationResolver) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
        this.annotationResolver = annotationResolver;
    }

    @Override
    @Nullable
    protected MethodInterceptor getInterceptor(Method method) {
        Counted annotation = this.annotationResolver.findAnnotation(Counted.class, method);
        if (annotation != null) {
            Counter counter = this.metricRegistry.counter(this.metricNamer.getNameForCounted(method, annotation));
            return new CountedInterceptor(counter, annotation);
        }
        return null;
    }
}

