/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.google.common.base.Preconditions;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.SimpleDeploymentContext;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;

public class ConfigurationBasedDeploymentContext
extends SimpleDeploymentContext {
    @Deprecated
    public static final String DEPLOYMENT_ENVIRONMENT_PROPERTY = "archaius.deployment.environment";
    @Deprecated
    public static final String DEPLOYMENT_DATACENTER_PROPERTY = "archaius.deployment.datacenter";
    @Deprecated
    public static final String DEPLOYMENT_APPLICATION_ID_PROPERTY = "archaius.deployment.applicationId";
    @Deprecated
    public static final String DEPLOYMENT_SERVER_ID_PROPERTY = "archaius.deployment.serverId";
    @Deprecated
    public static final String DEPLOYMENT_STACK_PROPERTY = "archaius.deployment.stack";
    @Deprecated
    public static final String DEPLOYMENT_REGION_PROPERTY = "archaius.deployment.region";
    private ConfigurationListener configListener = new ConfigurationListener(){

        public void configurationChanged(ConfigurationEvent event) {
            String value;
            if (event.isBeforeUpdate() || event.getType() != 1 && event.getType() != 3) {
                return;
            }
            String name = event.getPropertyName();
            String string = value = event.getPropertyValue() == null ? null : String.valueOf(event.getPropertyValue());
            if (value == null) {
                return;
            }
            if (name.equals(ConfigurationBasedDeploymentContext.DEPLOYMENT_ENVIRONMENT_PROPERTY)) {
                ConfigurationBasedDeploymentContext.super.setDeploymentRegion(value);
                ConfigurationBasedDeploymentContext.this.setValueInConfig(DeploymentContext.ContextKey.environment.getKey(), value);
            } else if (name.equals(ConfigurationBasedDeploymentContext.DEPLOYMENT_DATACENTER_PROPERTY)) {
                ConfigurationBasedDeploymentContext.super.setDeploymentDatacenter(value);
                ConfigurationBasedDeploymentContext.this.setValueInConfig(DeploymentContext.ContextKey.datacenter.getKey(), value);
            } else if (name.equals(ConfigurationBasedDeploymentContext.DEPLOYMENT_STACK_PROPERTY)) {
                ConfigurationBasedDeploymentContext.super.setDeploymentStack(value);
                ConfigurationBasedDeploymentContext.this.setValueInConfig(DeploymentContext.ContextKey.stack.getKey(), value);
            } else if (name.equals(ConfigurationBasedDeploymentContext.DEPLOYMENT_APPLICATION_ID_PROPERTY)) {
                ConfigurationBasedDeploymentContext.super.setApplicationId(value);
                ConfigurationBasedDeploymentContext.this.setValueInConfig(DeploymentContext.ContextKey.appId.getKey(), value);
            } else if (name.equals(ConfigurationBasedDeploymentContext.DEPLOYMENT_REGION_PROPERTY)) {
                ConfigurationBasedDeploymentContext.super.setDeploymentRegion(value);
                ConfigurationBasedDeploymentContext.this.setValueInConfig(DeploymentContext.ContextKey.region.getKey(), value);
            } else if (name.equals(ConfigurationBasedDeploymentContext.DEPLOYMENT_SERVER_ID_PROPERTY)) {
                ConfigurationBasedDeploymentContext.super.setDeploymentServerId(value);
                ConfigurationBasedDeploymentContext.this.setValueInConfig(DeploymentContext.ContextKey.serverId.getKey(), value);
            }
        }
    };

    public ConfigurationBasedDeploymentContext() {
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        if (config != null) {
            String contextValue = this.getValueFromConfig(DEPLOYMENT_APPLICATION_ID_PROPERTY);
            if (contextValue != null) {
                this.setApplicationId(contextValue);
            }
            if ((contextValue = this.getValueFromConfig(DEPLOYMENT_DATACENTER_PROPERTY)) != null) {
                this.setDeploymentDatacenter(contextValue);
            }
            if ((contextValue = this.getValueFromConfig(DEPLOYMENT_ENVIRONMENT_PROPERTY)) != null) {
                this.setDeploymentEnvironment(contextValue);
            }
            if ((contextValue = this.getValueFromConfig(DEPLOYMENT_REGION_PROPERTY)) != null) {
                this.setDeploymentRegion(contextValue);
            }
            if ((contextValue = this.getValueFromConfig(DEPLOYMENT_STACK_PROPERTY)) != null) {
                this.setDeploymentStack(contextValue);
            }
            if ((contextValue = this.getValueFromConfig(DEPLOYMENT_SERVER_ID_PROPERTY)) != null) {
                this.setDeploymentStack(contextValue);
            }
            config.addConfigurationListener(this.configListener);
        }
    }

    @Override
    public String getDeploymentEnvironment() {
        String value = this.getValueFromConfig(DeploymentContext.ContextKey.environment.getKey());
        if (value != null) {
            return value;
        }
        value = this.getValueFromConfig(DEPLOYMENT_ENVIRONMENT_PROPERTY);
        if (value != null) {
            return value;
        }
        return super.getDeploymentEnvironment();
    }

    @Override
    public void setDeploymentEnvironment(String value) {
        super.setDeploymentEnvironment(value);
        this.setValueInConfig(DEPLOYMENT_ENVIRONMENT_PROPERTY, value);
        this.setValueInConfig(DeploymentContext.ContextKey.environment.getKey(), value);
    }

    @Override
    public String getDeploymentDatacenter() {
        String value = this.getValueFromConfig(DeploymentContext.ContextKey.datacenter.getKey());
        if (value != null) {
            return value;
        }
        value = this.getValueFromConfig(DEPLOYMENT_DATACENTER_PROPERTY);
        if (value != null) {
            return value;
        }
        return super.getDeploymentDatacenter();
    }

    @Override
    public void setDeploymentDatacenter(String value) {
        super.setDeploymentDatacenter(value);
        this.setValueInConfig(DEPLOYMENT_DATACENTER_PROPERTY, value);
        this.setValueInConfig(DeploymentContext.ContextKey.datacenter.getKey(), value);
    }

    @Override
    public String getApplicationId() {
        String value = this.getValueFromConfig(DeploymentContext.ContextKey.appId.getKey());
        if (value != null) {
            return value;
        }
        value = this.getValueFromConfig(DEPLOYMENT_APPLICATION_ID_PROPERTY);
        if (value != null) {
            return value;
        }
        return super.getApplicationId();
    }

    @Override
    public void setApplicationId(String value) {
        super.setApplicationId(value);
        this.setValueInConfig(DEPLOYMENT_APPLICATION_ID_PROPERTY, value);
        this.setValueInConfig(DeploymentContext.ContextKey.appId.getKey(), value);
    }

    @Override
    public String getDeploymentServerId() {
        String value = this.getValueFromConfig(DeploymentContext.ContextKey.serverId.getKey());
        if (value != null) {
            return value;
        }
        value = this.getValueFromConfig(DEPLOYMENT_SERVER_ID_PROPERTY);
        if (value != null) {
            return value;
        }
        return super.getDeploymentServerId();
    }

    @Override
    public void setDeploymentServerId(String value) {
        super.setDeploymentServerId(value);
        this.setValueInConfig(DEPLOYMENT_SERVER_ID_PROPERTY, value);
        this.setValueInConfig(DeploymentContext.ContextKey.serverId.getKey(), value);
    }

    @Override
    public String getDeploymentStack() {
        String value = this.getValueFromConfig(DeploymentContext.ContextKey.stack.getKey());
        if (value != null) {
            return value;
        }
        value = this.getValueFromConfig(DEPLOYMENT_STACK_PROPERTY);
        if (value != null) {
            return value;
        }
        return super.getDeploymentStack();
    }

    @Override
    public void setDeploymentStack(String value) {
        super.setDeploymentStack(value);
        this.setValueInConfig(DEPLOYMENT_STACK_PROPERTY, value);
        this.setValueInConfig(DeploymentContext.ContextKey.stack.getKey(), value);
    }

    @Override
    public String getDeploymentRegion() {
        String value = this.getValueFromConfig(DeploymentContext.ContextKey.region.getKey());
        if (value != null) {
            return value;
        }
        value = this.getValueFromConfig(DEPLOYMENT_REGION_PROPERTY);
        if (value != null) {
            return value;
        }
        return super.getDeploymentRegion();
    }

    @Override
    public void setDeploymentRegion(String value) {
        super.setDeploymentRegion(value);
        this.setValueInConfig(DEPLOYMENT_REGION_PROPERTY, value);
        this.setValueInConfig(DeploymentContext.ContextKey.region.getKey(), value);
    }

    private String getValueFromConfig(String name) {
        AbstractConfiguration conf = ConfigurationManager.getConfigInstance();
        if (conf == null) {
            return null;
        }
        String value = (String)conf.getProperty(name);
        if (value != null) {
            return value;
        }
        value = System.getProperty(name);
        if (value != null) {
            return value;
        }
        return null;
    }

    private void setValueInConfig(String name, String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        ConfigurationManager.getConfigInstance().setProperty(name, (Object)value);
    }

    @Override
    public String getValue(DeploymentContext.ContextKey key) {
        String value = this.getValueFromConfig(key.getKey());
        if (value != null) {
            return value;
        }
        return super.getValue(key);
    }
}

